/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import com.google.common.primitives.Bytes;
import org.jboss.netty.channel.Channel;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.io.util.IsisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisHelloPduSender
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IsisHelloPduSender.class);
    private Channel channel = null;
    private IsisInterface isisInterface = null;

    public IsisHelloPduSender(Channel channel, IsisInterface isisInterface) {
        this.channel = channel;
        this.isisInterface = isisInterface;
    }

    @Override
    public void run() {
        if (this.channel != null && this.channel.isConnected() && this.channel.isOpen()) {
            try {
                byte[] helloPdu = null;
                byte[] interfaceIndex = new byte[]{(byte)this.isisInterface.interfaceIndex()};
                if (this.isisInterface.networkType() == IsisNetworkType.P2P) {
                    helloPdu = IsisUtil.getP2pHelloPdu((IsisInterface)this.isisInterface, (boolean)true);
                    helloPdu = Bytes.concat((byte[][])new byte[][]{helloPdu, interfaceIndex});
                    this.channel.write((Object)helloPdu);
                } else if (this.isisInterface.networkType() == IsisNetworkType.BROADCAST) {
                    switch (IsisRouterType.get((int)this.isisInterface.reservedPacketCircuitType())) {
                        case L1: {
                            helloPdu = IsisUtil.getL1HelloPdu((IsisInterface)this.isisInterface, (boolean)true);
                            helloPdu = Bytes.concat((byte[][])new byte[][]{helloPdu, interfaceIndex});
                            this.channel.write((Object)helloPdu);
                            break;
                        }
                        case L2: {
                            helloPdu = IsisUtil.getL2HelloPdu((IsisInterface)this.isisInterface, (boolean)true);
                            helloPdu = Bytes.concat((byte[][])new byte[][]{helloPdu, interfaceIndex});
                            this.channel.write((Object)helloPdu);
                            break;
                        }
                        case L1L2: {
                            helloPdu = IsisUtil.getL1HelloPdu((IsisInterface)this.isisInterface, (boolean)true);
                            helloPdu = Bytes.concat((byte[][])new byte[][]{helloPdu, interfaceIndex});
                            this.channel.write((Object)helloPdu);
                            helloPdu = IsisUtil.getL2HelloPdu((IsisInterface)this.isisInterface, (boolean)true);
                            helloPdu = Bytes.concat((byte[][])new byte[][]{helloPdu, interfaceIndex});
                            this.channel.write((Object)helloPdu);
                            break;
                        }
                        default: {
                            log.debug("IsisHelloPduSender::Unknown circuit type...!!!");
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debug("Exception @IsisHelloPduSender:: {}", (Object)e.getMessage());
            }
        }
    }
}

