/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.Controller;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLink;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLinkInformation;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLinkTed;
import org.onosproject.isis.controller.impl.topology.DefaultIsisRouter;
import org.onosproject.isis.controller.impl.topology.TopologyForDeviceAndLinkImpl;
import org.onosproject.isis.controller.topology.IsisLink;
import org.onosproject.isis.controller.topology.IsisLinkTed;
import org.onosproject.isis.controller.topology.IsisRouter;
import org.onosproject.isis.controller.topology.LinkInformation;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.isispacket.tlv.IsExtendedReachability;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.NeighborForExtendedIs;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.InterfaceIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumReservableBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.NeighborIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringMetric;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;
import org.onosproject.isis.io.util.IsisConstants;
import org.onosproject.isis.io.util.IsisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LspEventConsumer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LspEventConsumer.class);
    private BlockingQueue queue = null;
    private Controller controller = null;
    private TopologyForDeviceAndLinkImpl deviceAndLink = new TopologyForDeviceAndLinkImpl();
    private Map<String, IsisRouter> isisRouterDetails = new LinkedHashMap<String, IsisRouter>();

    public LspEventConsumer(BlockingQueue queue, Controller controller) {
        this.queue = queue;
        this.controller = controller;
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.queue.isEmpty()) {
                    continue;
                }
                LspWrapper wrapper = (LspWrapper)this.queue.take();
                LsPdu lsPdu = (LsPdu)wrapper.lsPdu();
                if (wrapper.lspProcessing().equals("LSP_REMOVED")) {
                    this.callTopologyToRemoveInfo(lsPdu);
                    continue;
                }
                if (!wrapper.lspProcessing().equals("LSP_ADDED")) continue;
                this.callTopologyToSendInfo(lsPdu, wrapper.isisInterface().networkType(), wrapper.isisInterface().systemId() + ".00");
            }
        }
        catch (Exception e) {
            log.debug("Error::LspsForProvider::{}", (Object)e.getMessage());
            return;
        }
    }

    private void callTopologyToSendInfo(LsPdu lsPdu, IsisNetworkType isisNetworkType, String ownSystemId) {
        if (lsPdu.lspId().equals(ownSystemId + "-00")) {
            return;
        }
        this.sendDeviceInfo(this.createDeviceInfo(lsPdu));
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighbours = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs teTlv : neighbours) {
                LinkInformation linkInformation;
                String neighbor = teTlv.neighborId();
                IsisRouter isisRouter = this.isisRouterDetails.get(neighbor);
                if (isisRouter == null) continue;
                IsisRouter sourceRouter = this.isisRouterDetails.get(IsisUtil.removeTailingZeros((String)lsPdu.lspId()));
                IsisRouter destinationRouter = isisRouter;
                if (sourceRouter.isDis()) {
                    linkInformation = this.createLinkInfo(sourceRouter.systemId(), destinationRouter.systemId(), sourceRouter.interfaceId(), destinationRouter.interfaceId(), lsPdu);
                    this.controller.addLinkDetails(this.createIsisLink(linkInformation, lsPdu));
                    continue;
                }
                if (destinationRouter.isDis()) {
                    LinkInformation linkInformation1 = this.createLinkInfo(destinationRouter.systemId(), sourceRouter.systemId(), destinationRouter.interfaceId(), sourceRouter.interfaceId(), lsPdu);
                    this.controller.addLinkDetails(this.createIsisLink(linkInformation1, lsPdu));
                    continue;
                }
                linkInformation = this.createLinkInfo(sourceRouter.systemId(), destinationRouter.systemId(), sourceRouter.interfaceId(), destinationRouter.interfaceId(), lsPdu);
                this.controller.addLinkDetails(this.createIsisLink(linkInformation, lsPdu));
                LinkInformation linkInformation1 = this.createLinkInfo(destinationRouter.systemId(), sourceRouter.systemId(), destinationRouter.interfaceId(), sourceRouter.interfaceId(), lsPdu);
                this.controller.addLinkDetails(this.createIsisLink(linkInformation1, lsPdu));
            }
        }
    }

    private void callTopologyToRemoveInfo(LsPdu lsPdu) {
        String routerId = IsisUtil.removeTailingZeros((String)lsPdu.lspId());
        IsisRouter isisRouter = this.isisRouterDetails.get(routerId);
        this.removeDeviceInfo(isisRouter);
        this.removeLinkInfo(lsPdu);
    }

    private void sendDeviceInfo(IsisRouter isisRouter) {
        if (isisRouter.systemId() != null) {
            this.controller.addDeviceDetails(isisRouter);
        }
    }

    public IsisRouter createDeviceInfo(LsPdu lsPdu) {
        IsisRouter isisRouter = this.createIsisRouter(lsPdu);
        if (isisRouter.systemId() != null) {
            this.isisRouterDetails.put(isisRouter.systemId(), isisRouter);
        }
        return isisRouter;
    }

    private IsisRouter createIsisRouter(LsPdu lsPdu) {
        DefaultIsisRouter isisRouter = new DefaultIsisRouter();
        if (IsisUtil.checkIsDis((String)lsPdu.lspId())) {
            isisRouter.setDis(true);
        } else {
            isisRouter.setDis(false);
        }
        isisRouter.setSystemId(IsisUtil.removeTailingZeros((String)lsPdu.lspId()));
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighbours = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs teTlv : neighbours) {
                List teSubTlvs = teTlv.teSubTlv();
                for (TrafficEngineeringSubTlv teSubTlv : teSubTlvs) {
                    if (teSubTlv instanceof InterfaceIpAddress) {
                        InterfaceIpAddress localIpAddress = (InterfaceIpAddress)teSubTlv;
                        isisRouter.setInterfaceId(localIpAddress.localInterfaceIPAddress());
                        continue;
                    }
                    if (!(teSubTlv instanceof NeighborIpAddress)) continue;
                    NeighborIpAddress neighborIpAddress = (NeighborIpAddress)teSubTlv;
                    isisRouter.setNeighborRouterId(neighborIpAddress.neighborIPAddress());
                }
            }
        }
        if (isisRouter.interfaceId() == null) {
            isisRouter.setInterfaceId(IsisConstants.DEFAULTIP);
        }
        if (isisRouter.neighborRouterId() == null) {
            isisRouter.setNeighborRouterId(IsisConstants.DEFAULTIP);
        }
        return isisRouter;
    }

    public LinkInformation createLinkInfo(String localSystemId, String remoteSystemId, Ip4Address interfaceIp, Ip4Address neighborIp, LsPdu lsPdu) {
        String linkId = "link:" + localSystemId + "-" + remoteSystemId;
        DefaultIsisLinkInformation linkInformation = new DefaultIsisLinkInformation();
        linkInformation.setInterfaceIp(interfaceIp);
        linkInformation.setNeighborIp(neighborIp);
        linkInformation.setLinkId(linkId);
        linkInformation.setAlreadyCreated(false);
        linkInformation.setLinkDestinationId(remoteSystemId);
        linkInformation.setLinkSourceId(localSystemId);
        return linkInformation;
    }

    private void removeDeviceInfo(IsisRouter isisRouter) {
        if (isisRouter.systemId() != null) {
            this.controller.removeDeviceDetails(isisRouter);
        }
        this.isisRouterDetails.remove(isisRouter.systemId());
    }

    private void removeLinkInfo(LsPdu lsPdu) {
        Map<String, LinkInformation> linkInformationList = this.deviceAndLink.removeLinkInfo(lsPdu.lspId());
        for (String key : linkInformationList.keySet()) {
            LinkInformation linkInformation = linkInformationList.get(key);
            this.controller.removeLinkDetails(this.createIsisLink(linkInformation, lsPdu));
        }
    }

    private IsisLink createIsisLink(LinkInformation linkInformation, LsPdu lsPdu) {
        DefaultIsisLink isisLink = new DefaultIsisLink();
        isisLink.setLocalSystemId(linkInformation.linkSourceId());
        isisLink.setRemoteSystemId(linkInformation.linkDestinationId());
        isisLink.setInterfaceIp(linkInformation.interfaceIp());
        isisLink.setNeighborIp(linkInformation.neighborIp());
        isisLink.setLinkTed(this.createIsisLinkTedInfo(lsPdu));
        return isisLink;
    }

    public IsisLinkTed createIsisLinkTedInfo(LsPdu lsPdu) {
        DefaultIsisLinkTed isisLinkTed = new DefaultIsisLinkTed();
        for (IsisTlv isisTlv : lsPdu.tlvs()) {
            if (!(isisTlv instanceof IsExtendedReachability)) continue;
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            List neighbours = isExtendedReachability.neighbours();
            for (NeighborForExtendedIs teTlv : neighbours) {
                List teSubTlvs = teTlv.teSubTlv();
                for (TrafficEngineeringSubTlv teSubTlv : teSubTlvs) {
                    if (teSubTlv instanceof AdministrativeGroup) {
                        AdministrativeGroup ag = (AdministrativeGroup)teSubTlv;
                        isisLinkTed.setAdministrativeGroup(ag.administrativeGroup());
                    }
                    if (teSubTlv instanceof InterfaceIpAddress) {
                        InterfaceIpAddress localIpAddress = (InterfaceIpAddress)teSubTlv;
                        isisLinkTed.setIpv4InterfaceAddress(localIpAddress.localInterfaceIPAddress());
                    }
                    if (teSubTlv instanceof NeighborIpAddress) {
                        NeighborIpAddress neighborIpAddress = (NeighborIpAddress)teSubTlv;
                        isisLinkTed.setIpv4NeighborAddress(neighborIpAddress.neighborIPAddress());
                    }
                    if (teSubTlv instanceof TrafficEngineeringMetric) {
                        TrafficEngineeringMetric teM = (TrafficEngineeringMetric)teSubTlv;
                        isisLinkTed.setTeDefaultMetric(teM.getTrafficEngineeringMetricValue());
                    }
                    if (teSubTlv instanceof MaximumBandwidth) {
                        MaximumBandwidth maxLinkBandwidth = (MaximumBandwidth)teSubTlv;
                        isisLinkTed.setMaximumLinkBandwidth(Bandwidth.bps((double)maxLinkBandwidth.getMaximumBandwidthValue()));
                    }
                    if (teSubTlv instanceof MaximumReservableBandwidth) {
                        MaximumReservableBandwidth maxReservableBw = (MaximumReservableBandwidth)teSubTlv;
                        isisLinkTed.setMaximumReservableLinkBandwidth(Bandwidth.bps((double)maxReservableBw.getMaximumBandwidthValue()));
                    }
                    if (!(teSubTlv instanceof UnreservedBandwidth)) continue;
                    UnreservedBandwidth unReservedBandwidth = (UnreservedBandwidth)teSubTlv;
                    ArrayList<Bandwidth> bandwidthList = new ArrayList<Bandwidth>();
                    List unReservedBandwidthList = unReservedBandwidth.unReservedBandwidthValue();
                    for (Float unReservedBandwidthFloatValue : unReservedBandwidthList) {
                        Bandwidth bandwidth = Bandwidth.bps((double)unReservedBandwidthFloatValue.floatValue());
                        bandwidthList.add(bandwidth);
                    }
                    isisLinkTed.setUnreservedBandwidth(bandwidthList);
                }
            }
        }
        return isisLinkTed;
    }
}

