/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisLsdb;
import org.onosproject.isis.controller.IsisLsdbAge;
import org.onosproject.isis.controller.IsisLspBin;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisNeighbor;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.Controller;
import org.onosproject.isis.controller.impl.LspEventConsumer;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLsdbAge;
import org.onosproject.isis.controller.impl.lsdb.DefaultLspWrapper;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.util.IsisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIsisLsdb
implements IsisLsdb {
    private static final Logger log = LoggerFactory.getLogger(DefaultIsisLsdb.class);
    private Map<String, LspWrapper> isisL1Db = new ConcurrentHashMap<String, LspWrapper>();
    private Map<String, LspWrapper> isisL2Db = new ConcurrentHashMap<String, LspWrapper>();
    private IsisLsdbAge lsdbAge = null;
    private Controller controller = null;
    private List<IsisInterface> isisInterfaceList = new ArrayList<IsisInterface>();
    private int l1LspSeqNo = 1;
    private int l2LspSeqNo = 1;
    private LspEventConsumer queueConsumer = null;
    private BlockingQueue<LspWrapper> lspForProviderQueue = new ArrayBlockingQueue<LspWrapper>(1024);

    public DefaultIsisLsdb() {
        this.lsdbAge = new DefaultIsisLsdbAge();
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setIsisInterface(List<IsisInterface> isisInterfaceList) {
        this.isisInterfaceList = isisInterfaceList;
    }

    public void initializeDb() {
        this.lsdbAge.startDbAging();
        this.queueConsumer = new LspEventConsumer(this.lspForProviderQueue, this.controller);
        new Thread(this.queueConsumer).start();
    }

    public void setL1LspSeqNo(int l1LspSeqNo) {
        this.l1LspSeqNo = l1LspSeqNo;
    }

    public void setL2LspSeqNo(int l2LspSeqNo) {
        this.l2LspSeqNo = l2LspSeqNo;
    }

    public String lspKey(String systemId) {
        StringBuilder lspKey = new StringBuilder();
        lspKey.append(systemId);
        lspKey.append(".00");
        lspKey.append("-");
        lspKey.append("00");
        return lspKey.toString();
    }

    public Map<String, LspWrapper> getL1Db() {
        return this.isisL1Db;
    }

    public Map<String, LspWrapper> getL2Db() {
        return this.isisL2Db;
    }

    public IsisLsdb isisLsdb() {
        return this;
    }

    public List<LspWrapper> allLspHeaders(boolean excludeMaxAgeLsp) {
        CopyOnWriteArrayList<LspWrapper> summaryList = new CopyOnWriteArrayList<LspWrapper>();
        this.addLspToHeaderList(summaryList, excludeMaxAgeLsp, this.isisL1Db);
        this.addLspToHeaderList(summaryList, excludeMaxAgeLsp, this.isisL2Db);
        return summaryList;
    }

    private void addLspToHeaderList(List summaryList, boolean excludeMaxAgeLsp, Map lspMap) {
        for (LspWrapper wrapper : lspMap.values()) {
            if (excludeMaxAgeLsp) {
                if (wrapper.remainingLifetime() == 0) continue;
                this.addToList(wrapper, summaryList);
                continue;
            }
            this.addToList(wrapper, summaryList);
        }
    }

    private void addToList(LspWrapper wrapper, List summList) {
        ((LsPdu)wrapper.lsPdu()).setRemainingLifeTime(wrapper.remainingLifetime());
        summList.add(wrapper);
    }

    public LspWrapper findLsp(IsisPduType pduType, String lspId) {
        LspWrapper lspWrapper = null;
        switch (pduType) {
            case L1LSPDU: {
                lspWrapper = this.isisL1Db.get(lspId);
                break;
            }
            case L2LSPDU: {
                lspWrapper = this.isisL2Db.get(lspId);
                break;
            }
            default: {
                log.debug("Unknown LSP type..!!!");
            }
        }
        if (lspWrapper != null) {
            ((DefaultLspWrapper)lspWrapper).lsPdu().setRemainingLifeTime(lspWrapper.remainingLifetime());
        }
        return lspWrapper;
    }

    public boolean addLsp(IsisMessage isisMessage, boolean isSelfOriginated, IsisInterface isisInterface) {
        DefaultLspWrapper lspWrapper;
        LsPdu lspdu = (LsPdu)isisMessage;
        if (isSelfOriginated) {
            byte[] lspBytes = lspdu.asBytes();
            lspdu.setPduLength(lspBytes.length);
            lspBytes = IsisUtil.addChecksum((byte[])lspBytes, (int)24, (int)25);
            byte[] checkSum = new byte[]{lspBytes[24], lspBytes[25]};
            lspdu.setCheckSum(ChannelBuffers.copiedBuffer((byte[])checkSum).readUnsignedShort());
        }
        if ((lspWrapper = (DefaultLspWrapper)this.findLsp(lspdu.isisPduType(), lspdu.lspId())) == null) {
            lspWrapper = new DefaultLspWrapper();
        }
        lspWrapper.setLspAgeReceived(1200 - lspdu.remainingLifeTime());
        lspWrapper.setLspType(IsisPduType.get((int)lspdu.pduType()));
        lspWrapper.setLsPdu(lspdu);
        lspWrapper.setAgeCounterWhenReceived(this.lsdbAge.ageCounter());
        lspWrapper.setAgeCounterRollOverWhenAdded(this.lsdbAge.ageCounterRollOver());
        lspWrapper.setSelfOriginated(isSelfOriginated);
        lspWrapper.setIsisInterface(isisInterface);
        lspWrapper.setLsdbAge(this.lsdbAge);
        this.addLsp(lspWrapper, lspdu.lspId());
        log.debug("Added LSp In LSDB: {}", (Object)lspWrapper);
        try {
            if (!lspWrapper.isSelfOriginated()) {
                lspWrapper.setLspProcessing("LSP_ADDED");
                this.lspForProviderQueue.put(lspWrapper);
            }
        }
        catch (Exception e) {
            log.debug("Added LSp In Blocking queue: {}", (Object)lspWrapper);
        }
        return true;
    }

    private boolean addLsp(LspWrapper lspWrapper, String key) {
        this.removeLspFromBin(lspWrapper);
        switch (lspWrapper.lsPdu().isisPduType()) {
            case L1LSPDU: {
                this.isisL1Db.remove(key);
                this.isisL1Db.put(key, lspWrapper);
                break;
            }
            case L2LSPDU: {
                this.isisL2Db.remove(key);
                this.isisL2Db.put(key, lspWrapper);
                break;
            }
            default: {
                log.debug("Unknown LSP type to add..!!!");
            }
        }
        Integer binNumber = this.lsdbAge.age2Bin(1200 - lspWrapper.lspAgeReceived());
        IsisLspBin lspBin = this.lsdbAge.getLspBin(binNumber.intValue());
        if (lspBin != null) {
            lspWrapper.setBinNumber(binNumber.intValue());
            lspBin.addIsisLsp(key, lspWrapper);
            this.lsdbAge.addLspBin(binNumber.intValue(), lspBin);
            log.debug("Added Type {} LSP to LSDB and LSABin[{}], Remaining life time of LSA {}", new Object[]{lspWrapper.lsPdu().isisPduType(), binNumber, lspWrapper.remainingLifetime()});
        }
        return false;
    }

    public void removeLspFromBin(LspWrapper lsaWrapper) {
        if (lsaWrapper != null) {
            this.lsdbAge.removeLspFromBin(lsaWrapper);
        }
    }

    public String isNewerOrSameLsp(IsisMessage lsp1, IsisMessage lsp2) {
        LsPdu receivedLsp = (LsPdu)lsp1;
        LsPdu lspFromDb = (LsPdu)lsp2;
        if (receivedLsp.sequenceNumber() > lspFromDb.sequenceNumber() || receivedLsp.checkSum() != lspFromDb.checkSum()) {
            return "latest";
        }
        if (receivedLsp.sequenceNumber() < lspFromDb.sequenceNumber()) {
            return "old";
        }
        if (receivedLsp.sequenceNumber() == lspFromDb.sequenceNumber()) {
            return "same";
        }
        return "";
    }

    public int lsSequenceNumber(IsisPduType lspType) {
        switch (lspType) {
            case L1LSPDU: {
                return this.l1LspSeqNo++;
            }
            case L2LSPDU: {
                return this.l2LspSeqNo++;
            }
        }
        return 1;
    }

    public void deleteLsp(IsisMessage lspMessage) {
        LsPdu lsp = (LsPdu)lspMessage;
        String lspKey = lsp.lspId();
        LspWrapper lspWrapper = this.findLsp(lspMessage.isisPduType(), lspKey);
        switch (lsp.isisPduType()) {
            case L1LSPDU: {
                this.isisL1Db.remove(lspKey);
                break;
            }
            case L2LSPDU: {
                this.isisL2Db.remove(lspKey);
                break;
            }
            default: {
                log.debug("Unknown LSP type to remove..!!!");
            }
        }
        try {
            lspWrapper.setLspProcessing("LSP_REMOVED");
            this.lspForProviderQueue.put(lspWrapper);
        }
        catch (Exception e) {
            log.debug("Added LSp In Blocking queue: {}", (Object)lspWrapper);
        }
    }

    public void removeTopology(IsisNeighbor neighbor, IsisInterface isisInterface) {
        String lspKey = neighbor.neighborSystemId() + ".00-00";
        LspWrapper lspWrapper = null;
        switch (IsisRouterType.get((int)isisInterface.reservedPacketCircuitType())) {
            case L1: {
                lspWrapper = this.findLsp(IsisPduType.L1LSPDU, lspKey);
                break;
            }
            case L2: {
                lspWrapper = this.findLsp(IsisPduType.L2LSPDU, lspKey);
                break;
            }
            case L1L2: {
                lspWrapper = this.findLsp(IsisPduType.L1LSPDU, lspKey);
                if (lspWrapper != null) break;
                lspWrapper = this.findLsp(IsisPduType.L2LSPDU, lspKey);
                break;
            }
            default: {
                log.debug("Unknown type");
            }
        }
        try {
            if (lspWrapper != null) {
                lspWrapper.setLspProcessing("LSP_REMOVED");
                this.lspForProviderQueue.put(lspWrapper);
            }
        }
        catch (Exception e) {
            log.debug("Added LSp In Blocking queue: {}", (Object)lspWrapper);
        }
    }
}

