/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisLsdbAge;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLspWrapper
implements LspWrapper {
    private static final Logger log = LoggerFactory.getLogger(DefaultLspWrapper.class);
    private int binNumber = -1;
    private boolean selfOriginated = false;
    private IsisPduType lspType;
    private int lspAgeReceived;
    private int ageCounterWhenReceived;
    private LsPdu lsPdu;
    private IsisLsdbAge lsdbAge;
    private int ageCounterRollOverWhenAdded;
    private int remainingLifetime;
    private IsisInterface isisInterface;
    private String lspProcessing;

    public String lspProcessing() {
        return this.lspProcessing;
    }

    public void setLspProcessing(String lspProcessing) {
        this.lspProcessing = lspProcessing;
    }

    public int lspAgeReceived() {
        return this.lspAgeReceived;
    }

    public void setLspAgeReceived(int lspAgeReceived) {
        this.lspAgeReceived = lspAgeReceived;
    }

    public IsisInterface isisInterface() {
        return this.isisInterface;
    }

    public void setIsisInterface(IsisInterface isisInterface) {
        this.isisInterface = isisInterface;
    }

    public int ageCounterWhenReceived() {
        return this.ageCounterWhenReceived;
    }

    public void setAgeCounterWhenReceived(int ageCounterWhenReceived) {
        this.ageCounterWhenReceived = ageCounterWhenReceived;
    }

    public int ageCounterRollOverWhenAdded() {
        return this.ageCounterRollOverWhenAdded;
    }

    public void setAgeCounterRollOverWhenAdded(int ageCounterRollOverWhenAdded) {
        this.ageCounterRollOverWhenAdded = ageCounterRollOverWhenAdded;
    }

    public int binNumber() {
        return this.binNumber;
    }

    public void setBinNumber(int binNumber) {
        this.binNumber = binNumber;
    }

    public boolean isSelfOriginated() {
        return this.selfOriginated;
    }

    public void setSelfOriginated(boolean selfOriginated) {
        this.selfOriginated = selfOriginated;
    }

    public IsisPduType lspType() {
        return this.lspType;
    }

    public void setLspType(IsisPduType lspType) {
        this.lspType = lspType;
    }

    public LsPdu lsPdu() {
        return this.lsPdu;
    }

    public void setLsPdu(LsPdu lsPdu) {
        this.lsPdu = lsPdu;
    }

    public IsisLsdbAge lsdbAge() {
        return this.lsdbAge;
    }

    public void setLsdbAge(IsisLsdbAge lsdbAge) {
        this.lsdbAge = lsdbAge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int currentAge() {
        int currentAge = 0;
        if (this.lsdbAge.ageCounter() >= this.ageCounterWhenReceived) {
            if (!this.selfOriginated) {
                if (this.ageCounterRollOverWhenAdded != this.lsdbAge.ageCounterRollOver()) return 1200;
                currentAge = this.lspAgeReceived + (this.lsdbAge.ageCounter() - this.ageCounterWhenReceived);
            } else {
                currentAge = this.lspAgeReceived + (this.lsdbAge.ageCounter() - this.ageCounterWhenReceived);
            }
        } else {
            currentAge = this.lspAgeReceived + (1200 + this.lsdbAge.ageCounter() - this.ageCounterWhenReceived);
        }
        if (currentAge >= 1200) {
            return 1200;
        }
        if (currentAge != this.lspAgeReceived || this.ageCounterRollOverWhenAdded == this.lsdbAge.ageCounterRollOver()) return currentAge;
        return 1200;
    }

    public int remainingLifetime() {
        this.remainingLifetime = 1200 - this.currentAge();
        return this.remainingLifetime;
    }

    public void setRemainingLifetime(int remainingLifetime) {
        this.remainingLifetime = remainingLifetime;
    }
}

