/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket;

import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.io.isispacket.IsisHeader;

public class IsisHeaderTest {
    private IsisHeader isisHeader;
    private MacAddress macAddress = MacAddress.valueOf((String)"a4:23:05:00:00:00");
    private int result;
    private MacAddress result1;
    private byte result2;
    private IsisPduType result3;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.isisHeader = new IsisHeader();
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.isisHeader = null;
    }

    @Test
    public void testInterfaceIndex() throws Exception {
        this.isisHeader.setInterfaceIndex(1);
        this.result = this.isisHeader.interfaceIndex();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetInterfaceIndex() throws Exception {
        this.isisHeader.setInterfaceIndex(1);
        this.result = this.isisHeader.interfaceIndex();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testInterfaceMac() throws Exception {
        this.isisHeader.setInterfaceMac(this.macAddress);
        this.result1 = this.isisHeader.interfaceMac();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)this.macAddress));
    }

    @Test
    public void testSourceMac() throws Exception {
        this.isisHeader.setSourceMac(this.macAddress);
        this.result1 = this.isisHeader.sourceMac();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)this.macAddress));
    }

    @Test
    public void testSetSourceMac() throws Exception {
        this.isisHeader.setSourceMac(this.macAddress);
        this.result1 = this.isisHeader.sourceMac();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)this.macAddress));
    }

    @Test
    public void testSetInterfaceMac() throws Exception {
        this.isisHeader.setSourceMac(this.macAddress);
        this.result1 = this.isisHeader.sourceMac();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)this.macAddress));
    }

    @Test
    public void testVersion2() throws Exception {
        this.isisHeader.setVersion2((byte)1);
        this.result2 = this.isisHeader.version2();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetVersion2() throws Exception {
        this.isisHeader.setVersion2((byte)1);
        this.result2 = this.isisHeader.version2();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testMaximumAreaAddresses() throws Exception {
        this.isisHeader.setMaximumAreaAddresses((byte)1);
        this.result2 = this.isisHeader.maximumAreaAddresses();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetMaximumAreaAddresses() throws Exception {
        this.isisHeader.setMaximumAreaAddresses((byte)1);
        this.result2 = this.isisHeader.maximumAreaAddresses();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testReserved() throws Exception {
        this.isisHeader.setReserved((byte)1);
        this.result2 = this.isisHeader.reserved();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetReserved() throws Exception {
        this.isisHeader.setReserved((byte)1);
        this.result2 = this.isisHeader.reserved();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testVersion() throws Exception {
        this.isisHeader.setVersion((byte)1);
        this.result2 = this.isisHeader.version();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetVersion() throws Exception {
        this.isisHeader.setVersion((byte)1);
        this.result2 = this.isisHeader.version();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testIdLength() throws Exception {
        this.isisHeader.setIdLength((byte)1);
        this.result2 = this.isisHeader.idLength();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetIdLength() throws Exception {
        this.isisHeader.setIdLength((byte)1);
        this.result2 = this.isisHeader.idLength();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testPduType() throws Exception {
        this.isisHeader.setIsisPduType(1);
        this.result = this.isisHeader.pduType();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetIsisPduType() throws Exception {
        this.isisHeader.setIsisPduType(1);
        this.result = this.isisHeader.pduType();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testPduHeaderLength() throws Exception {
        this.isisHeader.setPduHeaderLength((byte)1);
        this.result2 = this.isisHeader.pduHeaderLength();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetPduHeaderLength() throws Exception {
        this.isisHeader.setPduHeaderLength((byte)1);
        this.result2 = this.isisHeader.pduHeaderLength();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testIrpDiscriminator() throws Exception {
        this.isisHeader.setIrpDiscriminator((byte)1);
        this.result2 = this.isisHeader.irpDiscriminator();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetIrpDiscriminator() throws Exception {
        this.isisHeader.setIrpDiscriminator((byte)1);
        this.result2 = this.isisHeader.irpDiscriminator();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testIsisPduType() throws Exception {
        this.isisHeader.setIsisPduType(IsisPduType.L1HELLOPDU.value());
        this.result3 = this.isisHeader.isisPduType();
        MatcherAssert.assertThat((Object)this.result3, (Matcher)Matchers.is((Object)IsisPduType.L1HELLOPDU));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.isisHeader.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisHeader, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.isisHeader.asBytes();
        MatcherAssert.assertThat((Object)this.isisHeader, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPopulateHeader() throws Exception {
        this.isisHeader.populateHeader(new IsisHeader());
        MatcherAssert.assertThat((Object)this.isisHeader, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

