/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.Csnp;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class CsnpTest {
    private final String srcId = "1111.1111.1111";
    private final byte[] csnpBytes = new byte[]{0, 67, 18, 52, 18, 52, 0, 0, 67, 18, 52, 18, 52, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 9, 32, 4, -81, 18, 52, 18, 52, 0, 18, 0, 0, 0, 0, 0, 41, -92, -30, 4, -81, 41, 41, 41, 41, 41, 41, 0, 0, 0, 0, 0, 1, 91, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Csnp csnp;
    private IsisHeader isisHeader;
    private IsisTlv isisTlv;
    private TlvHeader tlvHeader;
    private List<IsisTlv> resultList;
    private String resultStr;
    private int resultInt;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.isisHeader = new IsisHeader();
        this.isisHeader.setIsisPduType(IsisPduType.L1CSNP.value());
        this.csnp = new Csnp(this.isisHeader);
        this.tlvHeader = new TlvHeader();
        this.isisTlv = new AdjacencyStateTlv(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.isisHeader = null;
        this.csnp = null;
        this.tlvHeader = null;
        this.isisTlv = null;
    }

    @Test
    public void testGetAllTlv() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.csnpBytes);
        this.csnp.readFrom(this.channelBuffer);
        this.resultList = this.csnp.getAllTlv();
        MatcherAssert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testSourceId() throws Exception {
        this.csnp.setSourceId("1111.1111.1111");
        this.resultStr = this.csnp.sourceId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetSourceId() throws Exception {
        this.csnp.setSourceId("1111.1111.1111");
        this.resultStr = this.csnp.sourceId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testStartLspId() throws Exception {
        this.csnp.setStartLspId("1111.1111.1111");
        this.resultStr = this.csnp.startLspId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetStartLspId() throws Exception {
        this.csnp.setStartLspId("1111.1111.1111");
        this.resultStr = this.csnp.startLspId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testEndLspId() throws Exception {
        this.csnp.setEndLspId("1111.1111.1111");
        this.resultStr = this.csnp.endLspId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetEndLspId() throws Exception {
        this.csnp.setEndLspId("1111.1111.1111");
        this.resultStr = this.csnp.endLspId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testPduLength() throws Exception {
        this.csnp.setPduLength(10);
        this.resultInt = this.csnp.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetPduLength() throws Exception {
        this.csnp.setPduLength(10);
        this.resultInt = this.csnp.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.csnpBytes);
        this.csnp.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.csnp, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.csnpBytes);
        this.csnp.readFrom(this.channelBuffer);
        this.result = this.csnp.asBytes();
        MatcherAssert.assertThat((Object)this.csnp, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testIsisPduHeader() throws Exception {
        this.result = this.csnp.isisPduHeader();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testCompleteSequenceNumberPduBody() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.csnpBytes);
        this.csnp.readFrom(this.channelBuffer);
        this.result = this.csnp.completeSequenceNumberPduBody();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.csnp.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.csnp.equals((Object)new Csnp(new IsisHeader())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        int hashCode = this.csnp.hashCode();
        MatcherAssert.assertThat((Object)hashCode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

