/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class HelloPduTest {
    private final byte[] macAddr = new byte[]{-92, 34, -62, 0, 0, 0};
    private final String srcId = "1111.1111.1111";
    private final byte[] helloL1L2 = new byte[]{1, 34, 34, 34, 34, 34, 34, 0, 30, 5, -39, 64, 34, 34, 34, 34, 34, 34, 1, -127, 1, -52, 1, 4, 3, 73, 0, 10, -124, 4, 10, 0, 10, 2, -45, 3, 0, 0, 0, 8, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private HelloPdu helloPdu;
    private IsisHeader isisHeader;
    private IsisTlv isisTlv;
    private TlvHeader tlvHeader;
    private MacAddress macAddress;
    private List<IsisTlv> resultList;
    private List<String> resultListStr;
    private List<Ip4Address> resultListIPv4;
    private List<MacAddress> resultListMac;
    private IsisInterfaceState resultAdjState;
    private String resultStr;
    private int resultInt;
    private byte resultByte;
    private ChannelBuffer channelBuffer;
    private HelloPdu pdu;

    @Before
    public void setUp() throws Exception {
        this.isisHeader = new IsisHeader();
        this.helloPdu = new L1L2HelloPdu(this.isisHeader);
        this.tlvHeader = new TlvHeader();
        this.isisTlv = new AdjacencyStateTlv(this.tlvHeader);
        this.macAddress = new MacAddress(this.macAddr);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
        this.pdu = this.helloPdu;
    }

    @After
    public void tearDown() throws Exception {
        this.isisHeader = null;
        this.helloPdu = null;
        this.isisTlv = null;
        this.tlvHeader = null;
        this.macAddress = null;
    }

    @Test
    public void testAddTlv() throws Exception {
        this.helloPdu.addTlv(this.isisTlv);
        this.resultList = this.helloPdu.tlvs();
        MatcherAssert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testTlvs() throws Exception {
        this.helloPdu.addTlv(this.isisTlv);
        this.resultList = this.helloPdu.tlvs();
        MatcherAssert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAreaAddress() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.helloL1L2);
        this.helloPdu.readFrom(this.channelBuffer);
        this.resultListStr = this.helloPdu.areaAddress();
        MatcherAssert.assertThat((Object)this.resultListStr.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testInterfaceIpAddresses() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.helloL1L2);
        this.helloPdu.readFrom(this.channelBuffer);
        this.resultListIPv4 = this.helloPdu.interfaceIpAddresses();
        MatcherAssert.assertThat((Object)this.resultListIPv4.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNeighborList() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.helloL1L2);
        this.helloPdu.readFrom(this.channelBuffer);
        this.resultListMac = this.helloPdu.neighborList();
        MatcherAssert.assertThat(this.resultListMac, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testAdjacencyState() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.helloL1L2);
        this.helloPdu.readFrom(this.channelBuffer);
        this.resultAdjState = this.helloPdu.adjacencyState();
        MatcherAssert.assertThat((Object)this.resultAdjState, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testSourceId() throws Exception {
        this.helloPdu.setSourceId("1111.1111.1111");
        this.resultStr = this.helloPdu.sourceId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetSourceId() throws Exception {
        this.helloPdu.setSourceId("1111.1111.1111");
        this.resultStr = this.helloPdu.sourceId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testPduLength() throws Exception {
        this.helloPdu.setPduLength(10);
        this.resultInt = this.helloPdu.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetPduLength() throws Exception {
        this.helloPdu.setPduLength(10);
        this.resultInt = this.helloPdu.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testHoldingTime() throws Exception {
        this.helloPdu.setHoldingTime(10);
        this.resultInt = this.helloPdu.holdingTime();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetHoldingTime() throws Exception {
        this.helloPdu.setHoldingTime(10);
        this.resultInt = this.helloPdu.holdingTime();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testCircuitType() throws Exception {
        this.helloPdu.setCircuitType((byte)1);
        this.resultByte = this.helloPdu.circuitType();
        MatcherAssert.assertThat((Object)this.resultByte, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetCircuitType() throws Exception {
        this.helloPdu.setCircuitType((byte)1);
        this.resultByte = this.helloPdu.circuitType();
        MatcherAssert.assertThat((Object)this.resultByte, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testToString() throws Exception {
        this.pdu = this.helloPdu;
        MatcherAssert.assertThat((Object)this.pdu.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testEquals() throws Exception {
        this.pdu = this.helloPdu;
        MatcherAssert.assertThat((Object)this.pdu.equals((Object)new L1L2HelloPdu(new IsisHeader())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        this.pdu = this.helloPdu;
        this.resultInt = this.pdu.hashCode();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

