/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.AttachedToOtherAreas;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.isispacket.tlv.HostNameTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class LsPduTest {
    private final String lspId = "1111.1111.1111";
    private final byte[] l1Lsp = new byte[]{0, 86, 4, -81, 34, 34, 34, 34, 34, 34, 0, 0, 0, 0, 0, 9, 99, 11, 1, 1, 4, 3, 73, 0, 10, -127, 1, -52, -119, 2, 82, 50, -124, 4, -64, -88, 10, 1, -128, 24, 10, -128, -128, -128, 10, 0, 10, 0, -1, -1, -1, -4, 10, -128, -128, -128, -64, -88, 10, 0, -1, -1, -1, 0, 2, 12, 0, 10, -128, -128, -128, 51, 51, 51, 51, 51, 51, 2};
    private LsPdu lsPdu;
    private IsisHeader isisHeader;
    private TlvHeader tlvHeader;
    private int resultInt;
    private boolean resultBool;
    private byte resultByte;
    private AttachedToOtherAreas resultObj;
    private String resultStr;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.isisHeader = new IsisHeader();
        this.tlvHeader = new TlvHeader();
        this.isisHeader.setIsisPduType(IsisPduType.L1LSPDU.value());
        this.lsPdu = new LsPdu(this.isisHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.isisHeader = null;
        this.lsPdu = null;
        this.tlvHeader = null;
        this.channelBuffer = null;
    }

    @Test
    public void testAddTlv() throws Exception {
        this.lsPdu.addTlv((IsisTlv)new HostNameTlv(this.tlvHeader));
        MatcherAssert.assertThat((Object)this.lsPdu, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemainingLifeTime() throws Exception {
        this.lsPdu.setRemainingLifeTime(10);
        this.resultInt = this.lsPdu.remainingLifeTime();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetRemainingLifeTime() throws Exception {
        this.lsPdu.setRemainingLifeTime(10);
        this.resultInt = this.lsPdu.remainingLifeTime();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testLspDbol() throws Exception {
        this.lsPdu.setLspDbol(true);
        this.resultBool = this.lsPdu.lspDbol();
        MatcherAssert.assertThat((Object)this.resultBool, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetLspDbol() throws Exception {
        this.lsPdu.setLspDbol(true);
        this.resultBool = this.lsPdu.lspDbol();
        MatcherAssert.assertThat((Object)this.resultBool, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTypeBlock() throws Exception {
        this.lsPdu.setTypeBlock((byte)1);
        this.resultByte = this.lsPdu.typeBlock();
        MatcherAssert.assertThat((Object)this.resultByte, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetTypeBlock() throws Exception {
        this.lsPdu.setTypeBlock((byte)1);
        this.resultByte = this.lsPdu.typeBlock();
        MatcherAssert.assertThat((Object)this.resultByte, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSequenceNumber() throws Exception {
        this.lsPdu.setSequenceNumber(1);
        this.resultInt = this.lsPdu.sequenceNumber();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetSequenceNumber() throws Exception {
        this.lsPdu.setSequenceNumber(1);
        this.resultInt = this.lsPdu.sequenceNumber();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testCheckSum() throws Exception {
        this.lsPdu.setCheckSum(1);
        this.resultInt = this.lsPdu.checkSum();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetCheckSum() throws Exception {
        this.lsPdu.setCheckSum(1);
        this.resultInt = this.lsPdu.checkSum();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testPartitionRepair() throws Exception {
        this.lsPdu.setPartitionRepair(true);
        this.resultBool = this.lsPdu.partitionRepair();
        MatcherAssert.assertThat((Object)this.resultBool, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetPartitionRepair() throws Exception {
        this.lsPdu.setPartitionRepair(true);
        this.resultBool = this.lsPdu.partitionRepair();
        MatcherAssert.assertThat((Object)this.resultBool, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testAttachedToOtherAreas() throws Exception {
        this.lsPdu.setAttachedToOtherAreas(AttachedToOtherAreas.DEFAULTMETRIC);
        this.resultObj = this.lsPdu.attachedToOtherAreas();
        MatcherAssert.assertThat((Object)this.resultObj, (Matcher)CoreMatchers.is((Object)AttachedToOtherAreas.DEFAULTMETRIC));
    }

    @Test
    public void testSetAttachedToOtherAreas() throws Exception {
        this.lsPdu.setAttachedToOtherAreas(AttachedToOtherAreas.DEFAULTMETRIC);
        this.resultObj = this.lsPdu.attachedToOtherAreas();
        MatcherAssert.assertThat((Object)this.resultObj, (Matcher)CoreMatchers.is((Object)AttachedToOtherAreas.DEFAULTMETRIC));
    }

    @Test
    public void testIntermediateSystemType() throws Exception {
        this.lsPdu.setIntermediateSystemType((byte)1);
        this.resultByte = this.lsPdu.intermediateSystemType();
        MatcherAssert.assertThat((Object)this.resultByte, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetIntermediateSystemType() throws Exception {
        this.lsPdu.setIntermediateSystemType((byte)1);
        this.resultByte = this.lsPdu.intermediateSystemType();
        MatcherAssert.assertThat((Object)this.resultByte, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testLspId() throws Exception {
        this.lsPdu.setLspId("1111.1111.1111");
        this.resultStr = this.lsPdu.lspId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetLspId() throws Exception {
        this.lsPdu.setLspId("1111.1111.1111");
        this.resultStr = this.lsPdu.lspId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testPduLength() throws Exception {
        this.lsPdu.setPduLength(10);
        this.resultInt = this.lsPdu.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetPduLength() throws Exception {
        this.lsPdu.setPduLength(10);
        this.resultInt = this.lsPdu.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.l1Lsp);
        this.lsPdu.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.lsPdu, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.l1Lsp);
        this.lsPdu.readFrom(this.channelBuffer);
        this.result = this.lsPdu.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testL1l2IsisPduHeader() throws Exception {
        this.result = this.lsPdu.l1l2IsisPduHeader();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testL1l2LsPduBody() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.l1Lsp);
        this.lsPdu.readFrom(this.channelBuffer);
        this.result = this.lsPdu.l1l2LsPduBody();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.lsPdu.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.lsPdu.equals((Object)new LsPdu(new IsisHeader())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        this.resultInt = this.lsPdu.hashCode();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

