/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.Psnp;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class PsnpTest {
    private final String srcId = "1111.1111.1111";
    private final byte[] psnpPkt = new byte[]{0, 35, 41, 41, 41, 41, 41, 41, 0, 9, 16, 4, -81, 18, 52, 18, 52, 0, 18, 0, 0, 0, 0, 0, 42, -94, -29};
    private Psnp psnp;
    private IsisHeader isisHeader;
    private ChannelBuffer channelBuffer;
    private IsisTlv isisTlv;
    private TlvHeader tlvHeader;
    private List<IsisTlv> resultList;
    private String resultStr;
    private int resultInt;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.isisHeader = new IsisHeader();
        this.isisHeader.setIsisPduType(IsisPduType.L1PSNP.value());
        this.psnp = new Psnp(this.isisHeader);
        this.tlvHeader = new TlvHeader();
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
        this.isisTlv = new AdjacencyStateTlv(this.tlvHeader);
    }

    @After
    public void tearDown() throws Exception {
        this.isisHeader = null;
        this.psnp = null;
        this.channelBuffer = null;
        this.tlvHeader = null;
        this.isisTlv = null;
        this.tlvHeader = null;
    }

    @Test
    public void testAddTlv() throws Exception {
        this.psnp.addTlv(this.isisTlv);
        this.resultList = this.psnp.getAllTlv();
        MatcherAssert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetAllTlv() throws Exception {
        this.psnp.addTlv(this.isisTlv);
        this.resultList = this.psnp.getAllTlv();
        MatcherAssert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSourceId() throws Exception {
        this.psnp.setSourceId("1111.1111.1111");
        this.resultStr = this.psnp.sourceId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetSourceId() throws Exception {
        this.psnp.setSourceId("1111.1111.1111");
        this.resultStr = this.psnp.sourceId();
        MatcherAssert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testPduLength() throws Exception {
        this.psnp.setPduLength(10);
        this.resultInt = this.psnp.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetPduLength() throws Exception {
        this.psnp.setPduLength(10);
        this.resultInt = this.psnp.pduLength();
        MatcherAssert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.psnpPkt);
        this.psnp.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.psnp, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.psnpPkt);
        this.psnp.readFrom(this.channelBuffer);
        this.result = this.psnp.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testIsisPduHeader() throws Exception {
        this.result = this.psnp.isisPduHeader();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testPartialSequenceNumberPduBody() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.psnpPkt);
        this.psnp.readFrom(this.channelBuffer);
        this.result = this.psnp.partialSequenceNumberPduBody();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.psnp.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.psnp.equals((Object)new Psnp(new IsisHeader())), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        int hashCode = this.psnp.hashCode();
        MatcherAssert.assertThat((Object)hashCode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

