/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class AdjacencyStateTlvTest {
    private final String neighborSystemId = "2929.2929.2929";
    private final byte[] tlv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private AdjacencyStateTlv adjacencyStateTlv;
    private TlvHeader tlvHeader;
    private int result;
    private byte result2;
    private String result1;
    private ChannelBuffer channelBuffer;
    private byte[] result3;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.adjacencyStateTlv = new AdjacencyStateTlv(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.adjacencyStateTlv = null;
        this.channelBuffer = null;
    }

    @Test
    public void testLocalCircuitId() throws Exception {
        this.adjacencyStateTlv.setLocalCircuitId(1);
        this.result = this.adjacencyStateTlv.localCircuitId();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetLocalCircuitId() throws Exception {
        this.adjacencyStateTlv.setLocalCircuitId(1);
        this.result = this.adjacencyStateTlv.localCircuitId();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testNeighborSystemId() throws Exception {
        this.adjacencyStateTlv.setNeighborSystemId("2929.2929.2929");
        this.result1 = this.adjacencyStateTlv.neighborSystemId();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)"2929.2929.2929"));
    }

    @Test
    public void testSetNeighborSystemId() throws Exception {
        this.adjacencyStateTlv.setNeighborSystemId("2929.2929.2929");
        this.result1 = this.adjacencyStateTlv.neighborSystemId();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)"2929.2929.2929"));
    }

    @Test
    public void testNeighborLocalCircuitId() throws Exception {
        this.adjacencyStateTlv.setNeighborLocalCircuitId(1);
        this.result = this.adjacencyStateTlv.neighborLocalCircuitId();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetNeighborLocalCircuitId() throws Exception {
        this.adjacencyStateTlv.setNeighborLocalCircuitId(1);
        this.result = this.adjacencyStateTlv.neighborLocalCircuitId();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testAdjacencyType() throws Exception {
        this.adjacencyStateTlv.setAdjacencyType((byte)1);
        this.result2 = this.adjacencyStateTlv.adjacencyType();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetAdjacencyType() throws Exception {
        this.adjacencyStateTlv.setAdjacencyType((byte)1);
        this.result2 = this.adjacencyStateTlv.adjacencyType();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.adjacencyStateTlv.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.adjacencyStateTlv.adjacencyType(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.adjacencyStateTlv.readFrom(this.channelBuffer);
        this.result3 = this.adjacencyStateTlv.asBytes();
        MatcherAssert.assertThat((Object)this.result3, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.adjacencyStateTlv.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

