/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.HostNameTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class HostNameTlvTest {
    private final String hostName = "TEST";
    private final byte[] tlv = "TEST".getBytes();
    private HostNameTlv hostNameTlv;
    private TlvHeader tlvHeader;
    private String result;
    private ChannelBuffer channelBuffer;
    private byte[] result1;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(this.tlv.length);
        this.hostNameTlv = new HostNameTlv(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.hostNameTlv = null;
    }

    @Test
    public void testHostName() throws Exception {
        this.hostNameTlv.setHostName("TEST");
        this.result = this.hostNameTlv.hostName();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void testSetHostName() throws Exception {
        this.hostNameTlv.setHostName("TEST");
        this.result = this.hostNameTlv.hostName();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.hostNameTlv.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.hostNameTlv.hostName(), (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.hostNameTlv.readFrom(this.channelBuffer);
        this.result1 = this.hostNameTlv.asBytes();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.hostNameTlv.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

