/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.IpExtendedReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;

public class IpExtendedReachabilityTlvTest {
    private final String prefix = "00";
    private final byte[] tlv = new byte[]{0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] tlv1 = new byte[]{0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] tlv2 = new byte[]{0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] tlv3 = new byte[]{0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0};
    private TlvHeader tlvHeader;
    private IpExtendedReachabilityTlv ipExtendedReachabilityTlv;
    private String result;
    private boolean result1;
    private int result2;
    private TrafficEngineeringSubTlv trafficEngineeringSubTlv;
    private byte result4;
    private ChannelBuffer channelBuffer;
    private byte[] result3;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.ipExtendedReachabilityTlv = new IpExtendedReachabilityTlv(this.tlvHeader);
        this.trafficEngineeringSubTlv = new AdministrativeGroup(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.ipExtendedReachabilityTlv = null;
    }

    @Test
    public void testPrefix() throws Exception {
        this.ipExtendedReachabilityTlv.setPrefix("00");
        this.result = this.ipExtendedReachabilityTlv.prefix();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)"00"));
    }

    @Test
    public void testSetPrefix() throws Exception {
        this.ipExtendedReachabilityTlv.setPrefix("00");
        this.result = this.ipExtendedReachabilityTlv.prefix();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)"00"));
    }

    @Test
    public void testIsDown() throws Exception {
        this.ipExtendedReachabilityTlv.setDown(true);
        this.result1 = this.ipExtendedReachabilityTlv.isDown();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetDown() throws Exception {
        this.ipExtendedReachabilityTlv.setDown(true);
        this.result1 = this.ipExtendedReachabilityTlv.isDown();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSubTlvPresence() throws Exception {
        this.ipExtendedReachabilityTlv.setSubTlvPresence(true);
        this.result1 = this.ipExtendedReachabilityTlv.isSubTlvPresence();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetSubTlvPresence() throws Exception {
        this.ipExtendedReachabilityTlv.setSubTlvPresence(true);
        this.result1 = this.ipExtendedReachabilityTlv.isSubTlvPresence();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testPrefixLength() throws Exception {
        this.ipExtendedReachabilityTlv.setPrefixLength(10);
        this.result2 = this.ipExtendedReachabilityTlv.prefixLength();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetPrefixLength() throws Exception {
        this.ipExtendedReachabilityTlv.setPrefixLength(10);
        this.result2 = this.ipExtendedReachabilityTlv.prefixLength();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testAddSubTlv() throws Exception {
        this.ipExtendedReachabilityTlv.addSubTlv(this.trafficEngineeringSubTlv);
        Assert.assertThat((Object)this.ipExtendedReachabilityTlv, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSubTlvLength() throws Exception {
        this.ipExtendedReachabilityTlv.setSubTlvLength((byte)10);
        this.result4 = this.ipExtendedReachabilityTlv.subTlvLength();
        Assert.assertThat((Object)this.result4, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetSubTlvLength() throws Exception {
        this.ipExtendedReachabilityTlv.setSubTlvLength((byte)10);
        this.result4 = this.ipExtendedReachabilityTlv.subTlvLength();
        Assert.assertThat((Object)this.result4, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testMetric() throws Exception {
        this.ipExtendedReachabilityTlv.setMetric(10);
        this.result2 = this.ipExtendedReachabilityTlv.metric();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetMetric() throws Exception {
        this.ipExtendedReachabilityTlv.setMetric(10);
        this.result2 = this.ipExtendedReachabilityTlv.metric();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.ipExtendedReachabilityTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ipExtendedReachabilityTlv.metric(), (Matcher)CoreMatchers.is((Object)0));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv1);
        this.ipExtendedReachabilityTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ipExtendedReachabilityTlv.metric(), (Matcher)CoreMatchers.is((Object)0));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv2);
        this.ipExtendedReachabilityTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ipExtendedReachabilityTlv.metric(), (Matcher)CoreMatchers.is((Object)0));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv3);
        this.ipExtendedReachabilityTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ipExtendedReachabilityTlv.metric(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.ipExtendedReachabilityTlv.readFrom(this.channelBuffer);
        this.ipExtendedReachabilityTlv.setPrefix("00");
        this.result3 = this.ipExtendedReachabilityTlv.asBytes();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.ipExtendedReachabilityTlv.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

