/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IpInterfaceAddressTlvTest {
    private final Ip4Address ip4Address = Ip4Address.valueOf((String)"10.10.10.10");
    private final byte[] tlv = new byte[]{0, 0, 0, 0};
    private TlvHeader tlvHeader;
    private IpInterfaceAddressTlv ipInterfaceAddressTlv;
    private List<Ip4Address> resultList;
    private byte[] result;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.ipInterfaceAddressTlv = new IpInterfaceAddressTlv(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.ipInterfaceAddressTlv = null;
    }

    @Test
    public void testAddInterfaceAddres() throws Exception {
        this.ipInterfaceAddressTlv.addInterfaceAddres(this.ip4Address);
        this.resultList = this.ipInterfaceAddressTlv.interfaceAddress();
        Assert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testInterfaceAddress() throws Exception {
        this.ipInterfaceAddressTlv.addInterfaceAddres(this.ip4Address);
        this.resultList = this.ipInterfaceAddressTlv.interfaceAddress();
        Assert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.ipInterfaceAddressTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ipInterfaceAddressTlv.interfaceAddress().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.ipInterfaceAddressTlv.readFrom(this.channelBuffer);
        this.result = this.ipInterfaceAddressTlv.asBytes();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.ipInterfaceAddressTlv.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

