/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.IpInternalReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.MetricOfInternalReachability;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IpInternalReachabilityTlvTest {
    private final byte[] tlv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private TlvHeader tlvHeader;
    private IpInternalReachabilityTlv ipInternalReachabilityTlv;
    private MetricOfInternalReachability metricOfInternalReachability;
    private byte[] result;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.ipInternalReachabilityTlv = new IpInternalReachabilityTlv(this.tlvHeader);
        this.metricOfInternalReachability = new MetricOfInternalReachability();
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.ipInternalReachabilityTlv = null;
    }

    @Test
    public void testAddInternalReachabilityMetric() throws Exception {
        this.ipInternalReachabilityTlv.addInternalReachabilityMetric(this.metricOfInternalReachability);
        Assert.assertThat((Object)this.ipInternalReachabilityTlv, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.ipInternalReachabilityTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ipInternalReachabilityTlv, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.ipInternalReachabilityTlv.readFrom(this.channelBuffer);
        this.result = this.ipInternalReachabilityTlv.asBytes();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.ipInternalReachabilityTlv.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

