/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.IsReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.MetricsOfReachability;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IsReachabilityTlvTest {
    private final byte[] tlv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private TlvHeader tlvHeader;
    private IsReachabilityTlv isReachabilityTlv;
    private MetricsOfReachability metricsOfReachability;
    private int resultInt;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.isReachabilityTlv = new IsReachabilityTlv(this.tlvHeader);
        this.metricsOfReachability = new MetricsOfReachability();
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.isReachabilityTlv = null;
    }

    @Test
    public void testReserved() throws Exception {
        this.isReachabilityTlv.setReserved(10);
        this.resultInt = this.isReachabilityTlv.reserved();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetReserved() throws Exception {
        this.isReachabilityTlv.setReserved(10);
        this.resultInt = this.isReachabilityTlv.reserved();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testAddMeticsOfReachability() throws Exception {
        this.isReachabilityTlv.addMeticsOfReachability(this.metricsOfReachability);
        Assert.assertThat((Object)this.isReachabilityTlv, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.isReachabilityTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.isReachabilityTlv, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.isReachabilityTlv.readFrom(this.channelBuffer);
        this.result = this.isReachabilityTlv.asBytes();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.isReachabilityTlv.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

