/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IsisNeighborTlvTest {
    private final MacAddress macAddress = MacAddress.valueOf((String)"a4:23:05:00:00:00");
    private final byte[] tlv = new byte[]{0, 0, 0, 0, 0, 0};
    private TlvHeader tlvHeader;
    private IsisNeighborTlv isisNeighborTlv;
    private List<MacAddress> resultList;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.isisNeighborTlv = new IsisNeighborTlv(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.isisNeighborTlv = null;
    }

    @Test
    public void testAddNeighbor() throws Exception {
        this.isisNeighborTlv.addNeighbor(this.macAddress);
        this.resultList = this.isisNeighborTlv.neighbor();
        Assert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNeighbor() throws Exception {
        this.isisNeighborTlv.addNeighbor(this.macAddress);
        this.resultList = this.isisNeighborTlv.neighbor();
        Assert.assertThat((Object)this.resultList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.isisNeighborTlv.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.isisNeighborTlv.neighbor().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.isisNeighborTlv.readFrom(this.channelBuffer);
        this.result = this.isisNeighborTlv.asBytes();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.isisNeighborTlv.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

