/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.LspEntriesTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntry;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class LspEntriesTlvTest {
    private final byte[] entry = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private LspEntriesTlv lspEntriesTlv;
    private TlvHeader tlvHeader;
    private List<LspEntry> lspEntries = new ArrayList<LspEntry>();
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.lspEntriesTlv = new LspEntriesTlv(this.tlvHeader);
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.lspEntriesTlv = null;
        this.lspEntries.clear();
    }

    @Test
    public void testLspEntry() throws Exception {
        this.lspEntriesTlv.addLspEntry(new LspEntry());
        Assert.assertThat((Object)this.lspEntriesTlv.lspEntry().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAddLspEntry() throws Exception {
        this.lspEntriesTlv.addLspEntry(new LspEntry());
        Assert.assertThat((Object)this.lspEntriesTlv.lspEntry().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.entry);
        this.lspEntriesTlv.readFrom(this.channelBuffer);
        this.lspEntries = this.lspEntriesTlv.lspEntry();
        Assert.assertThat((Object)this.lspEntriesTlv.lspEntry().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.entry);
        this.lspEntriesTlv.readFrom(this.channelBuffer);
        this.lspEntriesTlv.asBytes();
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.lspEntriesTlv.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

