/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.ProtocolSupportedTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class ProtocolSupportedTlvTest {
    private final byte[] tlv = new byte[]{0};
    private ProtocolSupportedTlv protocolSupportedTlv;
    private TlvHeader tlvHeader;
    private List<Byte> supported;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.protocolSupportedTlv = new ProtocolSupportedTlv(this.tlvHeader);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.protocolSupportedTlv = null;
        this.channelBuffer = null;
    }

    @Test
    public void testAddProtocolSupported() throws Exception {
        this.protocolSupportedTlv.addProtocolSupported((byte)1);
        this.supported = this.protocolSupportedTlv.protocolSupported();
        MatcherAssert.assertThat((Object)this.supported.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testProtocolSupported() throws Exception {
        this.protocolSupportedTlv.addProtocolSupported((byte)1);
        this.supported = this.protocolSupportedTlv.protocolSupported();
        MatcherAssert.assertThat((Object)this.supported.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.protocolSupportedTlv.readFrom(this.channelBuffer);
        this.supported = this.protocolSupportedTlv.protocolSupported();
        MatcherAssert.assertThat((Object)this.supported.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.protocolSupportedTlv.readFrom(this.channelBuffer);
        this.result = this.protocolSupportedTlv.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.protocolSupportedTlv.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

