/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.HostNameTlv;
import org.onosproject.isis.io.isispacket.tlv.IdrpInformationTlv;
import org.onosproject.isis.io.isispacket.tlv.IpExtendedReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInternalReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntriesTlv;
import org.onosproject.isis.io.isispacket.tlv.PaddingTlv;
import org.onosproject.isis.io.isispacket.tlv.ProtocolSupportedTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvFinder;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;

public class TlvFinderTest {
    private final byte[] tlv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] tlv1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private TlvFinder tlvFinder;
    private TlvHeader tlvHeader;
    private ChannelBuffer channelBuffer;
    private IsisTlv isisTlv;

    @Before
    public void setUp() throws Exception {
        this.tlvFinder = new TlvFinder();
        this.tlvHeader = new TlvHeader();
    }

    @After
    public void tearDown() throws Exception {
        this.tlvFinder = null;
        this.isisTlv = null;
    }

    @Test
    public void testIsisTlv() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(AreaAddressTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.HOSTNAME.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(HostNameTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.IDRPINFORMATION.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(IdrpInformationTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.IPEXTENDEDREACHABILITY.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(IpExtendedReachabilityTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.IPINTERFACEADDRESS.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(IpInterfaceAddressTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.IPINTERNALREACHABILITY.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(IpInternalReachabilityTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.PROTOCOLSUPPORTED.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(ProtocolSupportedTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.ISREACHABILITY.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(IsReachabilityTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.ISNEIGHBORS.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(IsisNeighborTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.LSPENTRY.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(LspEntriesTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv);
        this.tlvHeader.setTlvType(TlvType.PADDING.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(PaddingTlv.class));
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.tlv1);
        this.tlvHeader.setTlvType(TlvType.ADJACENCYSTATE.value());
        this.isisTlv = TlvFinder.findTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.isisTlv, (Matcher)Matchers.instanceOf(AdjacencyStateTlv.class));
    }
}

