/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.HostNameTlv;
import org.onosproject.isis.io.isispacket.tlv.IpExtendedReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInternalReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsExtendedReachability;
import org.onosproject.isis.io.isispacket.tlv.IsReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.MetricOfInternalReachability;
import org.onosproject.isis.io.isispacket.tlv.MetricsOfReachability;
import org.onosproject.isis.io.isispacket.tlv.NeighborForExtendedIs;
import org.onosproject.isis.io.isispacket.tlv.PaddingTlv;
import org.onosproject.isis.io.isispacket.tlv.ProtocolSupportedTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.isispacket.tlv.TlvsToBytes;

public class TlvsToBytesTest {
    private final String areaAddress = "49";
    private final Ip4Address ip4Address = Ip4Address.valueOf((String)"10.10.10.10");
    private final String systemName = "ROUTER";
    private final String neighborId = "2929.2929.2929";
    private List<Byte> tlv;
    private MacAddress macAddress = MacAddress.valueOf((String)"a4:23:05:00:00:00");
    private String prefix = "192.168.7";

    @Test
    public void testTlvToBytes() throws Exception {
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        tlvHeader.setTlvLength(0);
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress("49");
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)areaAddressTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.PROTOCOLSUPPORTED.value());
        tlvHeader.setTlvLength(0);
        ProtocolSupportedTlv protocolSupportedTlv = new ProtocolSupportedTlv(tlvHeader);
        protocolSupportedTlv.addProtocolSupported((byte)-52);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)protocolSupportedTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.IPINTERFACEADDRESS.value());
        tlvHeader.setTlvLength(0);
        IpInterfaceAddressTlv ipInterfaceAddressTlv = new IpInterfaceAddressTlv(tlvHeader);
        ipInterfaceAddressTlv.addInterfaceAddres(this.ip4Address);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)ipInterfaceAddressTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.HOSTNAME.value());
        tlvHeader.setTlvLength(0);
        HostNameTlv hostNameTlv = new HostNameTlv(tlvHeader);
        hostNameTlv.setHostName("ROUTER");
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)hostNameTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.ISREACHABILITY.value());
        tlvHeader.setTlvLength(0);
        IsReachabilityTlv isReachabilityTlv = new IsReachabilityTlv(tlvHeader);
        isReachabilityTlv.setReserved(0);
        MetricsOfReachability metricsOfReachability = new MetricsOfReachability();
        metricsOfReachability.setDefaultMetric((byte)10);
        metricsOfReachability.setDefaultIsInternal(true);
        metricsOfReachability.setDelayMetric((byte)10);
        metricsOfReachability.setDelayIsInternal(true);
        metricsOfReachability.setDelayMetricSupported(true);
        metricsOfReachability.setExpenseMetric((byte)10);
        metricsOfReachability.setExpenseIsInternal(true);
        metricsOfReachability.setExpenseMetricSupported(true);
        metricsOfReachability.setErrorMetric((byte)10);
        metricsOfReachability.setErrorIsInternal(true);
        metricsOfReachability.setErrorMetricSupported(true);
        metricsOfReachability.setNeighborId("2929.2929.2929");
        isReachabilityTlv.addMeticsOfReachability(metricsOfReachability);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)isReachabilityTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.IPINTERNALREACHABILITY.value());
        tlvHeader.setTlvLength(0);
        IpInternalReachabilityTlv ipInterReacTlv = new IpInternalReachabilityTlv(tlvHeader);
        MetricOfInternalReachability metricOfIntRea = new MetricOfInternalReachability();
        metricOfIntRea.setDefaultMetric((byte)10);
        metricOfIntRea.setDefaultIsInternal(true);
        metricOfIntRea.setDefaultDistributionDown(true);
        metricOfIntRea.setDelayMetric((byte)0);
        metricOfIntRea.setDelayMetricSupported(false);
        metricOfIntRea.setDelayIsInternal(true);
        metricOfIntRea.setExpenseMetric((byte)0);
        metricOfIntRea.setExpenseMetricSupported(false);
        metricOfIntRea.setExpenseIsInternal(true);
        metricOfIntRea.setErrorMetric((byte)0);
        metricOfIntRea.setErrorMetricSupported(false);
        metricOfIntRea.setExpenseIsInternal(true);
        metricOfIntRea.setIpAddress(this.ip4Address);
        metricOfIntRea.setSubnetAddres(this.ip4Address);
        ipInterReacTlv.addInternalReachabilityMetric(metricOfIntRea);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)ipInterReacTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.PADDING.value());
        tlvHeader.setTlvLength(255);
        PaddingTlv paddingTlv = new PaddingTlv(tlvHeader);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)paddingTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.IPEXTENDEDREACHABILITY.value());
        tlvHeader.setTlvLength(0);
        IpExtendedReachabilityTlv extendedTlv = new IpExtendedReachabilityTlv(tlvHeader);
        extendedTlv.setDown(false);
        extendedTlv.setMetric(10);
        extendedTlv.setPrefix(this.prefix);
        extendedTlv.setPrefixLength(24);
        extendedTlv.setSubTlvLength((byte)0);
        extendedTlv.setSubTlvPresence(false);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)extendedTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.ADJACENCYSTATE.value());
        tlvHeader.setTlvLength(0);
        AdjacencyStateTlv adjacencyStateTlv = new AdjacencyStateTlv(tlvHeader);
        adjacencyStateTlv.setAdjacencyType((byte)IsisInterfaceState.DOWN.value());
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)adjacencyStateTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.ISNEIGHBORS.value());
        tlvHeader.setTlvLength(0);
        IsisNeighborTlv isisNeighborTlv = new IsisNeighborTlv(tlvHeader);
        isisNeighborTlv.addNeighbor(this.macAddress);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)isisNeighborTlv);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        tlvHeader.setTlvType(TlvType.EXTENDEDISREACHABILITY.value());
        tlvHeader.setTlvLength(0);
        IsExtendedReachability reachability = new IsExtendedReachability(tlvHeader);
        NeighborForExtendedIs forExtendedIs = new NeighborForExtendedIs();
        forExtendedIs.setMetric(10);
        forExtendedIs.setNeighborId("2929.2929.2929");
        reachability.addNeighbor(forExtendedIs);
        this.tlv = TlvsToBytes.tlvToBytes((IsisTlv)reachability);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

