/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.InterfaceIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumReservableBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvFinder;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvType;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringMetric;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;

public class SubTlvFinderTest {
    private final byte[] packet1 = new byte[]{0, 0, 0, 1};
    private TlvHeader tlvHeader;
    private ChannelBuffer channelBuffer;
    private TrafficEngineeringSubTlv tlv;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.channelBuffer = null;
    }

    @Test
    public void testFindSubTlv() throws Exception {
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(SubTlvType.ADMINISTRATIVEGROUP.value());
        AdministrativeGroup administrativeGroup = new AdministrativeGroup(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.tlv = SubTlvFinder.findSubTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(SubTlvType.TRAFFICENGINEERINGMETRIC.value());
        TrafficEngineeringMetric trafficEngineeringMetric = new TrafficEngineeringMetric(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.tlv = SubTlvFinder.findSubTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(SubTlvType.MAXIMUMBANDWIDTH.value());
        MaximumBandwidth maximumBandwidth = new MaximumBandwidth(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.tlv = SubTlvFinder.findSubTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(SubTlvType.MAXIMUMRESERVABLEBANDWIDTH.value());
        MaximumReservableBandwidth maximumReservableBandwidth = new MaximumReservableBandwidth(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.tlv = SubTlvFinder.findSubTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(SubTlvType.UNRESERVEDBANDWIDTH.value());
        UnreservedBandwidth unreservedBandwidth = new UnreservedBandwidth(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.tlv = SubTlvFinder.findSubTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(SubTlvType.INTERFACEADDRESS.value());
        InterfaceIpAddress ipInterfaceAddressTlv = new InterfaceIpAddress(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.tlv = SubTlvFinder.findSubTlv((TlvHeader)this.tlvHeader, (ChannelBuffer)this.channelBuffer);
        MatcherAssert.assertThat((Object)this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

