/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumReservableBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvToBytes;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringMetric;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;

public class SubTlvToBytesTest {
    private TlvHeader tlvHeader;
    private ChannelBuffer channelBuffer;
    private List<Byte> tlv;

    @Before
    public void setUp() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.channelBuffer = (ChannelBuffer)EasyMock.createMock(ChannelBuffer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.tlvHeader = null;
        this.channelBuffer = null;
    }

    @Test
    public void testTlvToBytes() throws Exception {
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(9);
        AdministrativeGroup administrativeGroup = new AdministrativeGroup(this.tlvHeader);
        this.tlv = SubTlvToBytes.tlvToBytes((TrafficEngineeringSubTlv)administrativeGroup);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(5);
        TrafficEngineeringMetric trafficEngineeringMetric = new TrafficEngineeringMetric(this.tlvHeader);
        this.tlv = SubTlvToBytes.tlvToBytes((TrafficEngineeringSubTlv)trafficEngineeringMetric);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(6);
        MaximumBandwidth maximumBandwidth = new MaximumBandwidth(this.tlvHeader);
        this.tlv = SubTlvToBytes.tlvToBytes((TrafficEngineeringSubTlv)maximumBandwidth);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(7);
        MaximumReservableBandwidth maximumReservableBandwidth = new MaximumReservableBandwidth(this.tlvHeader);
        this.tlv = SubTlvToBytes.tlvToBytes((TrafficEngineeringSubTlv)maximumReservableBandwidth);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvLength(4);
        this.tlvHeader.setTlvType(8);
        UnreservedBandwidth unreservedBandwidth = new UnreservedBandwidth(this.tlvHeader);
        this.tlv = SubTlvToBytes.tlvToBytes((TrafficEngineeringSubTlv)unreservedBandwidth);
        MatcherAssert.assertThat(this.tlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

