/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;

public class UnreservedBandwidthTest {
    private final byte[] packet = new byte[]{0, 0, 0, 1};
    private UnreservedBandwidth unreservedBandwidth;
    private TlvHeader header;
    private byte[] result;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.unreservedBandwidth = new UnreservedBandwidth(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.unreservedBandwidth = null;
        this.header = null;
        this.result = null;
        this.channelBuffer = null;
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.unreservedBandwidth.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddUnReservedBandwidth() throws Exception {
        this.unreservedBandwidth.addUnReservedBandwidth(123456.78f);
        MatcherAssert.assertThat((Object)this.unreservedBandwidth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvLength(4);
        this.header.setTlvType(8);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.unreservedBandwidth = new UnreservedBandwidth(this.header);
        this.unreservedBandwidth.readFrom(this.channelBuffer);
        this.unreservedBandwidth.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.unreservedBandwidth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.unreservedBandwidth.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.result = this.unreservedBandwidth.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

