/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.util;

import com.google.common.primitives.Bytes;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.io.util.IsisUtil;

public class IsisUtilTest {
    private final String systemId = "2929.2929.2929";
    private final String lanId = "2929.2929.2929.01";
    private final String areaAddres = "490001";
    private final byte[] l1Lsp = new byte[]{-125, 27, 1, 0, 18, 1, 0, 0, 0, 86, 4, -81, 34, 34, 34, 34, 34, 34, 0, 0, 0, 0, 0, 9, 99, 11, 1, 1, 4, 3, 73, 0, 10, -127, 1, -52, -119, 2, 82, 50, -124, 4, -64, -88, 10, 1, -128, 24, 10, -128, -128, -128, 10, 0, 10, 0, -1, -1, -1, -4, 10, -128, -128, -128, -64, -88, 10, 0, -1, -1, -1, 0, 2, 12, 0, 10, -128, -128, -128, 51, 51, 51, 51, 51, 51, 2};
    private final byte[] intger = new byte[]{0, 0, 0, 1};
    private Ip4Address ip4Address1 = Ip4Address.valueOf((String)"10.10.10.10");
    private Ip4Address ip4Address2 = Ip4Address.valueOf((String)"10.10.10.11");
    private Ip4Address mask = Ip4Address.valueOf((String)"255.255.255.0");
    private boolean result;
    private String result1;
    private byte[] result2;
    private int result3;
    private long result4;
    private byte[] prefixBytes = new byte[]{0, 0, 0, 1};
    private String prefix = "192.16.17";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSameNetwork() throws Exception {
        this.result = IsisUtil.sameNetwork((Ip4Address)this.ip4Address1, (Ip4Address)this.ip4Address2, (byte[])this.mask.toOctets());
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSystemId() throws Exception {
        this.result1 = IsisUtil.systemId((byte[])Bytes.toArray((Collection)IsisUtil.sourceAndLanIdToBytes((String)"2929.2929.2929")));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"2929.2929.2929"));
    }

    @Test
    public void testSystemIdPlus() throws Exception {
        this.result1 = IsisUtil.systemIdPlus((byte[])Bytes.toArray((Collection)IsisUtil.sourceAndLanIdToBytes((String)"2929.2929.2929.01")));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"2929.2929.2929.01"));
    }

    @Test
    public void testAreaAddres() throws Exception {
        this.result1 = IsisUtil.areaAddres((byte[])Bytes.toArray((Collection)IsisUtil.areaAddressToBytes((String)"490001")));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"490001"));
    }

    @Test
    public void testAreaAddressToBytes() throws Exception {
        this.result2 = Bytes.toArray((Collection)IsisUtil.areaAddressToBytes((String)"490001"));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetPduHeaderLength() throws Exception {
        this.result3 = IsisUtil.getPduHeaderLength((int)IsisPduType.L1CSNP.value());
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)33));
        this.result3 = IsisUtil.getPduHeaderLength((int)IsisPduType.L1PSNP.value());
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)17));
        this.result3 = IsisUtil.getPduHeaderLength((int)IsisPduType.L1HELLOPDU.value());
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)27));
        this.result3 = IsisUtil.getPduHeaderLength((int)IsisPduType.P2PHELLOPDU.value());
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)20));
    }

    @Test
    public void testAddLengthAndMarkItInReserved() throws Exception {
        this.result2 = IsisUtil.addLengthAndMarkItInReserved((byte[])this.l1Lsp, (int)8, (int)9, (int)6);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAddChecksum() throws Exception {
        this.result2 = IsisUtil.addChecksum((byte[])this.l1Lsp, (int)24, (int)25);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testFramePacket() throws Exception {
        this.result2 = IsisUtil.framePacket((byte[])this.l1Lsp, (int)2);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSourceAndLanIdToBytes() throws Exception {
        this.result2 = Bytes.toArray((Collection)IsisUtil.sourceAndLanIdToBytes((String)"2929.2929.2929.01"));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetPaddingTlvs() throws Exception {
        this.result2 = IsisUtil.getPaddingTlvs((int)250);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testConvertToTwoBytes() throws Exception {
        this.result2 = IsisUtil.convertToTwoBytes((int)250);
        Assert.assertThat((Object)this.result2.length, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testConvertToFourBytes() throws Exception {
        this.result2 = IsisUtil.convertToFourBytes((int)250);
        Assert.assertThat((Object)this.result2.length, (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testByteToInteger() throws Exception {
        this.result3 = IsisUtil.byteToInteger((byte[])this.intger);
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testByteToLong() throws Exception {
        this.result4 = IsisUtil.byteToLong((byte[])this.intger);
        Assert.assertThat((Object)this.result4, (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testConvertToFourBytes1() throws Exception {
        this.result2 = IsisUtil.convertToFourBytes((long)250L);
        Assert.assertThat((Object)this.result2.length, (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testToEightBitBinary() throws Exception {
        this.result1 = IsisUtil.toEightBitBinary((String)"01");
        Assert.assertThat((Object)this.result1.length(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void testToFourBitBinary() throws Exception {
        this.result1 = IsisUtil.toFourBitBinary((String)"01");
        Assert.assertThat((Object)this.result1.length(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testConvertToThreeBytes() throws Exception {
        this.result2 = IsisUtil.convertToThreeBytes((int)30);
        Assert.assertThat((Object)this.result2.length, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testPrefixConversion() throws Exception {
        this.result1 = IsisUtil.prefixConversion((byte[])this.prefixBytes);
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testPrefixToBytes() throws Exception {
        this.result2 = IsisUtil.prefixToBytes((String)this.prefix);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

