/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvFinder;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.isispacket.tlv.TlvsToBytes;
import org.onosproject.isis.io.util.IsisUtil;

public class Csnp
extends IsisHeader {
    private int pduLength;
    private String sourceId;
    private String startLspId;
    private String endLspId;
    private List<IsisTlv> variableLengths = new ArrayList<IsisTlv>();

    public Csnp(IsisHeader isisHeader) {
        this.populateHeader(isisHeader);
    }

    public List<IsisTlv> getAllTlv() {
        return this.variableLengths;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String startLspId() {
        return this.startLspId;
    }

    public void setStartLspId(String startLspId) {
        this.startLspId = startLspId;
    }

    public String endLspId() {
        return this.endLspId;
    }

    public void setEndLspId(String endLspId) {
        this.endLspId = endLspId;
    }

    public int pduLength() {
        return this.pduLength;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setPduLength(channelBuffer.readUnsignedShort());
        byte[] tempByteArray = new byte[7];
        channelBuffer.readBytes(tempByteArray, 0, 7);
        this.setSourceId(IsisUtil.systemIdPlus(tempByteArray));
        tempByteArray = new byte[8];
        channelBuffer.readBytes(tempByteArray, 0, 8);
        this.setStartLspId(IsisUtil.systemIdPlus(tempByteArray));
        tempByteArray = new byte[8];
        channelBuffer.readBytes(tempByteArray, 0, 8);
        this.setEndLspId(IsisUtil.systemIdPlus(tempByteArray));
        while (channelBuffer.readableBytes() > 0) {
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(channelBuffer.readUnsignedByte());
            tlvHeader.setTlvLength(channelBuffer.readUnsignedByte());
            TlvType tlvValue = TlvType.get(tlvHeader.tlvType());
            if (tlvValue != null) {
                IsisTlv tlv = TlvFinder.findTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()));
                if (tlv == null) continue;
                this.variableLengths.add(tlv);
                continue;
            }
            channelBuffer.readBytes(tlvHeader.tlvLength());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] csnpMessage = null;
        byte[] isisPduHeader = this.isisPduHeader();
        byte[] csnpBody = this.completeSequenceNumberPduBody();
        csnpMessage = Bytes.concat((byte[][])new byte[][]{isisPduHeader, csnpBody});
        return csnpMessage;
    }

    public byte[] isisPduHeader() {
        ArrayList<Byte> headerList = new ArrayList<Byte>();
        headerList.add(this.irpDiscriminator());
        headerList.add((byte)IsisUtil.getPduHeaderLength(this.pduType()));
        headerList.add(this.version());
        headerList.add(this.idLength());
        headerList.add((byte)this.pduType());
        headerList.add(this.version2());
        headerList.add(this.reserved());
        headerList.add(this.maximumAreaAddresses());
        return Bytes.toArray(headerList);
    }

    public byte[] completeSequenceNumberPduBody() {
        ArrayList<Byte> bodyList = new ArrayList<Byte>();
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.pduLength())));
        bodyList.addAll(IsisUtil.sourceAndLanIdToBytes(this.sourceId()));
        bodyList.addAll(IsisUtil.sourceAndLanIdToBytes(this.startLspId()));
        bodyList.addAll(IsisUtil.sourceAndLanIdToBytes(this.endLspId()));
        for (IsisTlv isisTlv : this.variableLengths) {
            bodyList.addAll(TlvsToBytes.tlvToBytes(isisTlv));
        }
        return Bytes.toArray(bodyList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("pduLength", this.pduLength).add("sourceId", (Object)this.sourceId).add("startLspId", (Object)this.startLspId).add("endLspId", (Object)this.endLspId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Csnp that = (Csnp)o;
        return Objects.equal((Object)this.pduLength, (Object)that.pduLength) && Objects.equal((Object)this.sourceId, (Object)that.sourceId) && Objects.equal((Object)this.startLspId, (Object)that.startLspId) && Objects.equal((Object)this.endLspId, (Object)that.endLspId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pduLength, this.sourceId, this.startLspId, this.endLspId});
    }
}

