/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvFinder;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.isispacket.tlv.TlvsToBytes;
import org.onosproject.isis.io.util.IsisUtil;

public class L1L2HelloPdu
extends HelloPdu {
    private byte priority;
    private String lanId;

    public L1L2HelloPdu(IsisHeader isisHeader) {
        this.populateHeader(isisHeader);
    }

    public String lanId() {
        return this.lanId;
    }

    public void setLanId(String lanId) {
        this.lanId = lanId;
    }

    public byte priority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setCircuitType(channelBuffer.readByte());
        byte[] tempByteArray = new byte[6];
        channelBuffer.readBytes(tempByteArray, 0, 6);
        this.setSourceId(IsisUtil.systemId(tempByteArray));
        this.setHoldingTime(channelBuffer.readUnsignedShort());
        this.setPduLength(channelBuffer.readUnsignedShort());
        this.setPriority(channelBuffer.readByte());
        tempByteArray = new byte[7];
        channelBuffer.readBytes(tempByteArray, 0, 7);
        this.setLanId(IsisUtil.systemIdPlus(tempByteArray));
        while (channelBuffer.readableBytes() > 0) {
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(channelBuffer.readUnsignedByte());
            tlvHeader.setTlvLength(channelBuffer.readUnsignedByte());
            TlvType tlvType = TlvType.get(tlvHeader.tlvType());
            if (tlvType != null) {
                IsisTlv tlv = TlvFinder.findTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()));
                if (tlv == null) continue;
                this.variableLengths.add(tlv);
                continue;
            }
            channelBuffer.readBytes(tlvHeader.tlvLength());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] helloMessage = null;
        byte[] helloHeader = this.l1l2IsisPduHeader();
        byte[] helloBody = this.l1l2HelloPduBody();
        helloMessage = Bytes.concat((byte[][])new byte[][]{helloHeader, helloBody});
        return helloMessage;
    }

    public byte[] l1l2IsisPduHeader() {
        ArrayList<Byte> headerLst = new ArrayList<Byte>();
        headerLst.add(this.irpDiscriminator());
        headerLst.add((byte)IsisUtil.getPduHeaderLength(this.pduType()));
        headerLst.add(this.version());
        headerLst.add(this.idLength());
        headerLst.add((byte)this.pduType());
        headerLst.add(this.version2());
        headerLst.add(this.reserved());
        headerLst.add(this.maximumAreaAddresses());
        return Bytes.toArray(headerLst);
    }

    public byte[] l1l2HelloPduBody() {
        ArrayList<Byte> bodyLst = new ArrayList<Byte>();
        bodyLst.add(this.circuitType());
        bodyLst.addAll(IsisUtil.sourceAndLanIdToBytes(this.sourceId()));
        bodyLst.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.holdingTime())));
        bodyLst.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.pduLength())));
        bodyLst.add(this.priority);
        bodyLst.addAll(IsisUtil.sourceAndLanIdToBytes(this.lanId()));
        for (IsisTlv isisTlv : this.variableLengths) {
            bodyLst.addAll(TlvsToBytes.tlvToBytes(isisTlv));
        }
        return Bytes.toArray(bodyLst);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("priority", (int)this.priority).add("lanId", (Object)this.lanId).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        L1L2HelloPdu that = (L1L2HelloPdu)o;
        return Objects.equal((Object)this.priority, (Object)that.priority) && Objects.equal((Object)this.lanId, (Object)that.lanId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.priority, this.lanId});
    }
}

