/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.AttachedToOtherAreas;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvFinder;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.isispacket.tlv.TlvsToBytes;
import org.onosproject.isis.io.util.IsisUtil;

public class LsPdu
extends IsisHeader {
    private int pduLength;
    private int remainingLifeTime;
    private String lspId;
    private int sequenceNumber;
    private int checkSum;
    private boolean partitionRepair;
    private AttachedToOtherAreas attachedToOtherAreas;
    private boolean lspDbol;
    private byte typeBlock;
    private byte intermediateSystemType;
    private List<IsisTlv> variableLengths = new ArrayList<IsisTlv>();

    public LsPdu(IsisHeader isisHeader) {
        this.populateHeader(isisHeader);
    }

    public List<IsisTlv> tlvs() {
        return this.variableLengths;
    }

    public void addTlv(IsisTlv isisTlv) {
        this.variableLengths.add(isisTlv);
    }

    public int remainingLifeTime() {
        return this.remainingLifeTime;
    }

    public void setRemainingLifeTime(int remainingLifeTime) {
        this.remainingLifeTime = remainingLifeTime;
    }

    public boolean lspDbol() {
        return this.lspDbol;
    }

    public void setLspDbol(boolean lspDbol) {
        this.lspDbol = lspDbol;
    }

    public byte typeBlock() {
        return this.typeBlock;
    }

    public void setTypeBlock(byte typeBlock) {
        this.typeBlock = typeBlock;
    }

    public int sequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public int checkSum() {
        return this.checkSum;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public boolean partitionRepair() {
        return this.partitionRepair;
    }

    public void setPartitionRepair(boolean partitionRepair) {
        this.partitionRepair = partitionRepair;
    }

    public AttachedToOtherAreas attachedToOtherAreas() {
        return this.attachedToOtherAreas;
    }

    public void setAttachedToOtherAreas(AttachedToOtherAreas attachedToOtherAreas) {
        this.attachedToOtherAreas = attachedToOtherAreas;
    }

    public byte intermediateSystemType() {
        return this.intermediateSystemType;
    }

    public void setIntermediateSystemType(byte intermediateSystemType) {
        this.intermediateSystemType = intermediateSystemType;
    }

    public String lspId() {
        return this.lspId;
    }

    public void setLspId(String lspId) {
        this.lspId = lspId;
    }

    public int pduLength() {
        return this.pduLength;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setPduLength(channelBuffer.readUnsignedShort());
        this.setRemainingLifeTime(channelBuffer.readUnsignedShort());
        byte[] tempByteArray = new byte[8];
        channelBuffer.readBytes(tempByteArray, 0, 8);
        this.setLspId(IsisUtil.systemIdPlus(tempByteArray));
        this.setSequenceNumber(channelBuffer.readInt());
        this.setCheckSum(channelBuffer.readUnsignedShort());
        short typeTemp = channelBuffer.readUnsignedByte();
        byte isTypeByte = (byte)typeTemp;
        String tempValue = String.format("%8s", Integer.toBinaryString(isTypeByte & 0xFF)).replace(' ', '0');
        int pBit = Integer.parseInt(new Character(tempValue.charAt(0)).toString());
        if (pBit == 1) {
            this.setPartitionRepair(true);
        } else {
            this.setPartitionRepair(false);
        }
        int attValue = Integer.parseInt(tempValue.substring(1, 5), 2);
        switch (AttachedToOtherAreas.get(attValue)) {
            case DEFAULTMETRIC: {
                this.setAttachedToOtherAreas(AttachedToOtherAreas.DEFAULTMETRIC);
                break;
            }
            case DELAYMETRIC: {
                this.setAttachedToOtherAreas(AttachedToOtherAreas.DELAYMETRIC);
                break;
            }
            case EXPENSEMETRIC: {
                this.setAttachedToOtherAreas(AttachedToOtherAreas.EXPENSEMETRIC);
                break;
            }
            case ERRORMETRIC: {
                this.setAttachedToOtherAreas(AttachedToOtherAreas.ERRORMETRIC);
                break;
            }
            case NONE: {
                this.setAttachedToOtherAreas(AttachedToOtherAreas.NONE);
                break;
            }
        }
        int lspdbol = Integer.parseInt(new Character(tempValue.charAt(5)).toString());
        if (lspdbol == 1) {
            this.setLspDbol(true);
        } else {
            this.setLspDbol(false);
        }
        int isType = Integer.parseInt(tempValue.substring(6, 8), 2);
        byte isTypeByteValue = (byte)isType;
        this.setIntermediateSystemType(isTypeByteValue);
        while (channelBuffer.readableBytes() > 0) {
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(channelBuffer.readUnsignedByte());
            tlvHeader.setTlvLength(channelBuffer.readUnsignedByte());
            TlvType tlvValue = TlvType.get(tlvHeader.tlvType());
            if (tlvValue != null) {
                IsisTlv tlv = TlvFinder.findTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()));
                if (tlv == null) continue;
                this.variableLengths.add(tlv);
                continue;
            }
            channelBuffer.readBytes(tlvHeader.tlvLength());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] lspMessage = null;
        byte[] helloHeader = this.l1l2IsisPduHeader();
        byte[] lspBody = this.l1l2LsPduBody();
        lspMessage = Bytes.concat((byte[][])new byte[][]{helloHeader, lspBody});
        return lspMessage;
    }

    public byte[] l1l2IsisPduHeader() {
        ArrayList<Byte> headerList = new ArrayList<Byte>();
        headerList.add(this.irpDiscriminator());
        headerList.add((byte)IsisUtil.getPduHeaderLength(this.pduType()));
        headerList.add(this.version());
        headerList.add(this.idLength());
        headerList.add((byte)this.pduType());
        headerList.add(this.version2());
        headerList.add(this.reserved());
        headerList.add(this.maximumAreaAddresses());
        return Bytes.toArray(headerList);
    }

    public byte[] l1l2LsPduBody() {
        ArrayList<Byte> bodyList = new ArrayList<Byte>();
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.pduLength())));
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.remainingLifeTime())));
        bodyList.addAll(IsisUtil.sourceAndLanIdToBytes(this.lspId()));
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(this.sequenceNumber())));
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.checkSum())));
        String temString = "";
        temString = this.partitionRepair() ? "1" + temString : "0" + temString;
        switch (this.attachedToOtherAreas()) {
            case ERRORMETRIC: {
                temString = temString + "1000";
                break;
            }
            case EXPENSEMETRIC: {
                temString = temString + "0100";
                break;
            }
            case DELAYMETRIC: {
                temString = temString + "0010";
                break;
            }
            case DEFAULTMETRIC: {
                temString = temString + "0001";
                break;
            }
            case NONE: {
                temString = temString + "0000";
                break;
            }
        }
        temString = this.lspDbol() ? temString + "1" : temString + "0";
        String isType = Integer.toBinaryString(this.intermediateSystemType());
        if (isType.length() % 2 != 0) {
            isType = "0" + isType;
        }
        temString = temString + isType;
        bodyList.add((byte)Integer.parseInt(temString, 2));
        for (IsisTlv isisTlv : this.variableLengths) {
            bodyList.addAll(TlvsToBytes.tlvToBytes(isisTlv));
        }
        return Bytes.toArray(bodyList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("pduLength", this.pduLength).add("remainingLifeTime", this.remainingLifeTime).add("lspId", (Object)this.lspId).add("sequenceNumber", this.sequenceNumber).add("checkSum", this.checkSum).add("partitionRepair", this.partitionRepair).add("lspDbol", this.lspDbol).add("typeBlock", (int)this.typeBlock).add("intermediateSystemType", (int)this.intermediateSystemType).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LsPdu that = (LsPdu)o;
        return Objects.equal((Object)this.pduLength, (Object)that.pduLength) && Objects.equal((Object)this.remainingLifeTime, (Object)that.remainingLifeTime) && Objects.equal((Object)this.lspId, (Object)that.lspId) && Objects.equal((Object)this.sequenceNumber, (Object)that.sequenceNumber) && Objects.equal((Object)this.checkSum, (Object)that.checkSum) && Objects.equal((Object)this.partitionRepair, (Object)that.partitionRepair) && Objects.equal((Object)this.lspDbol, (Object)that.lspDbol) && Objects.equal((Object)this.typeBlock, (Object)that.typeBlock) && Objects.equal((Object)this.intermediateSystemType, (Object)that.intermediateSystemType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pduLength, this.remainingLifeTime, this.lspId, this.sequenceNumber, this.checkSum, this.partitionRepair, this.lspDbol, this.typeBlock, this.intermediateSystemType});
    }
}

