/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvFinder;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.isispacket.tlv.TlvsToBytes;
import org.onosproject.isis.io.util.IsisUtil;

public class P2PHelloPdu
extends HelloPdu {
    private byte localCircuitId;

    public P2PHelloPdu(IsisHeader isisHeader) {
        this.populateHeader(isisHeader);
    }

    public byte localCircuitId() {
        return this.localCircuitId;
    }

    public void setLocalCircuitId(byte localCircuitId) {
        this.localCircuitId = localCircuitId;
    }

    public void setVariableLengths(List<IsisTlv> variableLengths) {
        this.variableLengths = variableLengths;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setCircuitType(channelBuffer.readByte());
        byte[] tempByteArray = new byte[6];
        channelBuffer.readBytes(tempByteArray, 0, 6);
        this.setSourceId(IsisUtil.systemId(tempByteArray));
        this.setHoldingTime(channelBuffer.readUnsignedShort());
        this.setPduLength(channelBuffer.readUnsignedShort());
        this.setLocalCircuitId((byte)channelBuffer.readUnsignedByte());
        while (channelBuffer.readableBytes() > 0) {
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(channelBuffer.readUnsignedByte());
            tlvHeader.setTlvLength(channelBuffer.readUnsignedByte());
            TlvType tlvType = TlvType.get(tlvHeader.tlvType());
            if (tlvType != null) {
                IsisTlv tlv = TlvFinder.findTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()));
                if (tlv == null) continue;
                this.variableLengths.add(tlv);
                continue;
            }
            channelBuffer.readBytes(tlvHeader.tlvLength());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] helloMessage = null;
        byte[] helloHeader = this.p2PHeader();
        byte[] helloBody = this.p2P2HelloPduBody();
        helloMessage = Bytes.concat((byte[][])new byte[][]{helloHeader, helloBody});
        return helloMessage;
    }

    public byte[] p2PHeader() {
        ArrayList<Byte> headerList = new ArrayList<Byte>();
        headerList.add(this.irpDiscriminator());
        headerList.add((byte)IsisUtil.getPduHeaderLength(this.pduType()));
        headerList.add(this.version());
        headerList.add(this.idLength());
        headerList.add((byte)this.pduType());
        headerList.add(this.version2());
        headerList.add(this.reserved());
        headerList.add(this.maximumAreaAddresses());
        return Bytes.toArray(headerList);
    }

    public byte[] p2P2HelloPduBody() {
        ArrayList<Byte> bodyList = new ArrayList<Byte>();
        bodyList.add(this.circuitType());
        bodyList.addAll(IsisUtil.sourceAndLanIdToBytes(this.sourceId()));
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.holdingTime())));
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.pduLength())));
        bodyList.add(this.localCircuitId());
        for (IsisTlv isisTlv : this.variableLengths) {
            bodyList.addAll(TlvsToBytes.tlvToBytes(isisTlv));
        }
        return Bytes.toArray(bodyList);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("localCircuitId", (int)this.localCircuitId).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        P2PHelloPdu that = (P2PHelloPdu)o;
        return Objects.equal((Object)this.localCircuitId, (Object)that.localCircuitId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.localCircuitId});
    }
}

