/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.util.IsisUtil;

public class AdjacencyStateTlv
extends TlvHeader
implements IsisTlv {
    private byte adjacencyType;
    private int localCircuitId;
    private String neighborSystemId;
    private int neighborLocalCircuitId;

    public AdjacencyStateTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public int localCircuitId() {
        return this.localCircuitId;
    }

    public void setLocalCircuitId(int localCircuitId) {
        this.localCircuitId = localCircuitId;
    }

    public String neighborSystemId() {
        return this.neighborSystemId;
    }

    public void setNeighborSystemId(String neighborSystemId) {
        this.neighborSystemId = neighborSystemId;
    }

    public int neighborLocalCircuitId() {
        return this.neighborLocalCircuitId;
    }

    public void setNeighborLocalCircuitId(int neighborLocalCircuitId) {
        this.neighborLocalCircuitId = neighborLocalCircuitId;
    }

    public byte adjacencyType() {
        return this.adjacencyType;
    }

    public void setAdjacencyType(byte adjacencyType) {
        this.adjacencyType = adjacencyType;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setAdjacencyType(channelBuffer.readByte());
        this.setLocalCircuitId(channelBuffer.readInt());
        if (channelBuffer.readableBytes() > 0) {
            byte[] tempByteArray = new byte[6];
            channelBuffer.readBytes(tempByteArray, 0, 6);
            this.setNeighborSystemId(IsisUtil.systemId(tempByteArray));
            this.setNeighborLocalCircuitId(channelBuffer.readInt());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add(this.adjacencyType);
        bytes.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(this.localCircuitId)));
        if (this.neighborSystemId != null) {
            bytes.addAll(IsisUtil.sourceAndLanIdToBytes(this.neighborSystemId));
            bytes.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(this.neighborLocalCircuitId)));
        }
        return Bytes.toArray(bytes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("adjacencyType", (int)this.adjacencyType).add("localCircuitId", this.localCircuitId).add("neighborSystemId", (Object)this.neighborSystemId).add("neighborLocalCircuitId", this.neighborLocalCircuitId).toString();
    }
}

