/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.util.IsisUtil;

public class AreaAddressTlv
extends TlvHeader
implements IsisTlv {
    private List<String> areaAddress = new ArrayList<String>();

    public AreaAddressTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public void addAddress(String areaAddress) {
        this.areaAddress.add(areaAddress);
    }

    public List<String> areaAddress() {
        return this.areaAddress;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() > 0) {
            byte addressLength = channelBuffer.readByte();
            byte[] addressbytes = new byte[addressLength];
            channelBuffer.readBytes(addressbytes, 0, (int)addressLength);
            String areaAddress = IsisUtil.areaAddres(addressbytes);
            this.areaAddress.add(areaAddress);
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (String areaAddress : this.areaAddress) {
            bytes.add((byte)(areaAddress.length() / 2));
            bytes.addAll(IsisUtil.areaAddressToBytes(areaAddress));
        }
        return Bytes.toArray(bytes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("areaAddress", this.areaAddress).toString();
    }
}

