/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvFinder;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvToBytes;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvType;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.util.IsisUtil;

public class IpExtendedReachabilityTlv
extends TlvHeader
implements IsisTlv {
    private boolean down;
    private boolean subTlvPresence;
    private int prefixLength;
    private int metric;
    private byte subTlvLength;
    private String prefix;
    private List<TrafficEngineeringSubTlv> trafEnginSubTlv = new ArrayList<TrafficEngineeringSubTlv>();

    public IpExtendedReachabilityTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public List<TrafficEngineeringSubTlv> teTlvs() {
        return this.trafEnginSubTlv;
    }

    public String prefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean upOrDown) {
        this.down = upOrDown;
    }

    public boolean isSubTlvPresence() {
        return this.subTlvPresence;
    }

    public void setSubTlvPresence(boolean subTlvPresence) {
        this.subTlvPresence = subTlvPresence;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public void addSubTlv(TrafficEngineeringSubTlv trafEnginSubTlv) {
        this.trafEnginSubTlv.add(trafEnginSubTlv);
    }

    public byte subTlvLength() {
        return this.subTlvLength;
    }

    public void setSubTlvLength(byte subTlvLength) {
        this.subTlvLength = subTlvLength;
    }

    public int metric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setMetric(channelBuffer.readInt());
        byte controlInfo = channelBuffer.readByte();
        byte[] tempByteArray = null;
        String string = IsisUtil.toEightBitBinary(Integer.toBinaryString(controlInfo));
        if (string.charAt(0) == '0') {
            this.setDown(false);
        }
        if (string.charAt(1) == '1') {
            this.setSubTlvPresence(true);
        }
        this.setPrefixLength(Integer.parseInt(string.substring(2, string.length()), 2));
        if (this.prefixLength >= 0 && this.prefixLength <= 8) {
            channelBuffer.readByte();
        } else if (this.prefixLength >= 8 && this.prefixLength <= 16) {
            tempByteArray = new byte[2];
            channelBuffer.readBytes(tempByteArray, 0, 2);
            this.setPrefix(IsisUtil.prefixConversion(tempByteArray));
        } else if (this.prefixLength >= 17 && this.prefixLength <= 24) {
            tempByteArray = new byte[3];
            channelBuffer.readBytes(tempByteArray, 0, 3);
            this.setPrefix(IsisUtil.prefixConversion(tempByteArray));
        } else if (this.prefixLength >= 24 && this.prefixLength <= 32) {
            tempByteArray = new byte[4];
            channelBuffer.readBytes(tempByteArray, 0, 4);
            this.setPrefix(IsisUtil.prefixConversion(tempByteArray));
        }
        if (this.isSubTlvPresence()) {
            this.setSubTlvLength(channelBuffer.readByte());
            while (channelBuffer.readableBytes() > 0) {
                TlvHeader tlvHeader = new TlvHeader();
                tlvHeader.setTlvType(channelBuffer.readByte());
                tlvHeader.setTlvLength(channelBuffer.readByte());
                SubTlvType tlvValue = SubTlvType.get(tlvHeader.tlvType());
                if (tlvValue != null) {
                    TrafficEngineeringSubTlv subTlv = SubTlvFinder.findSubTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()));
                    if (subTlv == null) continue;
                    this.addSubTlv(subTlv);
                    continue;
                }
                channelBuffer.readBytes(tlvHeader.tlvLength());
            }
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList<Byte> bodyLst = new ArrayList<Byte>();
        bodyLst.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(this.metric())));
        String controlInfo = "";
        controlInfo = this.isDown() ? controlInfo + "1" : controlInfo + "0";
        controlInfo = this.isSubTlvPresence() ? controlInfo + "1" : controlInfo + "0";
        String prefixLength = IsisUtil.toEightBitBinary(Integer.toBinaryString(this.prefixLength()));
        controlInfo = controlInfo + prefixLength.substring(2, prefixLength.length());
        bodyLst.add(Byte.parseByte(controlInfo, 2));
        if (this.isSubTlvPresence()) {
            bodyLst.add(this.subTlvLength());
            for (TrafficEngineeringSubTlv trafficEngineeringSubTlv : this.trafEnginSubTlv) {
                bodyLst.addAll(SubTlvToBytes.tlvToBytes(trafficEngineeringSubTlv));
            }
        }
        bodyLst.addAll(Bytes.asList((byte[])IsisUtil.prefixToBytes(this.prefix())));
        return Bytes.toArray(bodyLst);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("down", this.down).add("subTlvPresence", this.subTlvPresence).add("prefixLength", this.prefixLength).add("metric", this.metric).add("subTlvLength", (int)this.subTlvLength).add("prefix", (Object)this.prefix).add("trafEnginSubTlv", this.trafEnginSubTlv).toString();
    }
}

