/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.NeighborForExtendedIs;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IsExtendedReachability
extends TlvHeader
implements IsisTlv {
    private List<NeighborForExtendedIs> neighbors = new ArrayList<NeighborForExtendedIs>();

    public IsExtendedReachability(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public List<NeighborForExtendedIs> neighbours() {
        return this.neighbors;
    }

    public void addNeighbor(NeighborForExtendedIs neighbor) {
        this.neighbors.add(neighbor);
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 11) {
            NeighborForExtendedIs extendedIs = new NeighborForExtendedIs();
            extendedIs.readFrom(channelBuffer);
            this.addNeighbor(extendedIs);
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList byteList = new ArrayList();
        for (NeighborForExtendedIs neighbor : this.neighbors) {
            byteList.addAll(Bytes.asList((byte[])neighbor.neighborBodyAsbytes()));
        }
        return Bytes.toArray(byteList);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("neighbors", this.neighbors).toString();
    }
}

