/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntry;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class LspEntriesTlv
extends TlvHeader
implements IsisTlv {
    private List<LspEntry> lspEntryList = new ArrayList<LspEntry>();

    public LspEntriesTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public List<LspEntry> lspEntry() {
        return this.lspEntryList;
    }

    public void addLspEntry(LspEntry lspEntry) {
        this.lspEntryList.add(lspEntry);
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 16) {
            LspEntry lspEntry = new LspEntry();
            lspEntry.readFrom(channelBuffer.readBytes(16));
            this.lspEntryList.add(lspEntry);
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList bytes = new ArrayList();
        for (LspEntry lspEntry : this.lspEntryList) {
            bytes.addAll(Bytes.asList((byte[])lspEntry.lspEntryAsBytes()));
        }
        return Bytes.toArray(bytes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("lspEntryList", this.lspEntryList).toString();
    }
}

