/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.util.IsisUtil;

public class LspEntry {
    private int lspSequenceNumber;
    private int lspChecksum;
    private int remainingTime;
    private String lspId;

    public int lspSequenceNumber() {
        return this.lspSequenceNumber;
    }

    public void setLspSequenceNumber(int lspSequenceNumber) {
        this.lspSequenceNumber = lspSequenceNumber;
    }

    public int lspChecksum() {
        return this.lspChecksum;
    }

    public void setLspChecksum(int lspChecksum) {
        this.lspChecksum = lspChecksum;
    }

    public int remainingTime() {
        return this.remainingTime;
    }

    public void setRemainingTime(int remainingTime) {
        this.remainingTime = remainingTime;
    }

    public String lspId() {
        return this.lspId;
    }

    public void setLspId(String lspId) {
        this.lspId = lspId;
    }

    public void readFrom(ChannelBuffer channelBuffer) {
        this.setRemainingTime(channelBuffer.readUnsignedShort());
        byte[] tempByteArray = new byte[8];
        channelBuffer.readBytes(tempByteArray, 0, 8);
        this.setLspId(IsisUtil.systemIdPlus(tempByteArray));
        this.setLspSequenceNumber(channelBuffer.readInt());
        this.setLspChecksum(channelBuffer.readUnsignedShort());
    }

    public byte[] lspEntryAsBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.remainingTime())));
        bytes.addAll(IsisUtil.sourceAndLanIdToBytes(this.lspId()));
        bytes.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(this.lspSequenceNumber())));
        bytes.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.lspChecksum())));
        return Bytes.toArray(bytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("lspSequenceNumber", this.lspSequenceNumber).add("lspChecksum", this.lspChecksum).add("remainingTime", this.remainingTime).add("lspId", (Object)this.lspId).toString();
    }
}

