/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.io.util.IsisUtil;

public class MetricOfInternalReachability {
    private Ip4Address ipAddress;
    private Ip4Address subnetAddres;
    private byte defaultMetric;
    private byte delayMetric;
    private byte expenseMetric;
    private byte errorMetric;
    private boolean delayMetricSupported;
    private boolean expenseMetricSupported;
    private boolean errorMetricSupported;
    private boolean defaultIsInternal;
    private boolean defaultDistributionDown;
    private boolean delayIsInternal;
    private boolean expenseIsInternal;
    private boolean errorIsInternal;

    public Ip4Address getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(Ip4Address ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Ip4Address getSubnetAddres() {
        return this.subnetAddres;
    }

    public void setSubnetAddres(Ip4Address subnetAddres) {
        this.subnetAddres = subnetAddres;
    }

    public boolean isErrorIsInternal() {
        return this.errorIsInternal;
    }

    public void setErrorIsInternal(boolean errorIsInternal) {
        this.errorIsInternal = errorIsInternal;
    }

    public boolean isExpenseIsInternal() {
        return this.expenseIsInternal;
    }

    public void setExpenseIsInternal(boolean expenseIsInternal) {
        this.expenseIsInternal = expenseIsInternal;
    }

    public boolean isDelayIsInternal() {
        return this.delayIsInternal;
    }

    public void setDelayIsInternal(boolean delayIsInternal) {
        this.delayIsInternal = delayIsInternal;
    }

    public boolean isDefaultDistributionDown() {
        return this.defaultDistributionDown;
    }

    public void setDefaultDistributionDown(boolean defaultDistributionDown) {
        this.defaultDistributionDown = defaultDistributionDown;
    }

    public boolean isDefaultIsInternal() {
        return this.defaultIsInternal;
    }

    public void setDefaultIsInternal(boolean defaultIsInternal) {
        this.defaultIsInternal = defaultIsInternal;
    }

    public boolean isErrorMetricSupported() {
        return this.errorMetricSupported;
    }

    public void setErrorMetricSupported(boolean errorMetricSupported) {
        this.errorMetricSupported = errorMetricSupported;
    }

    public boolean isExpenseMetricSupported() {
        return this.expenseMetricSupported;
    }

    public void setExpenseMetricSupported(boolean expenseMetricSupported) {
        this.expenseMetricSupported = expenseMetricSupported;
    }

    public boolean isDelayMetricSupported() {
        return this.delayMetricSupported;
    }

    public void setDelayMetricSupported(boolean delayMetricSupported) {
        this.delayMetricSupported = delayMetricSupported;
    }

    public byte errorMetric() {
        return this.errorMetric;
    }

    public void setErrorMetric(byte errorMetric) {
        this.errorMetric = errorMetric;
    }

    public byte expenseMetric() {
        return this.expenseMetric;
    }

    public void setExpenseMetric(byte expenseMetric) {
        this.expenseMetric = expenseMetric;
    }

    public byte delayMetric() {
        return this.delayMetric;
    }

    public void setDelayMetric(byte delayMetric) {
        this.delayMetric = delayMetric;
    }

    public byte defaultMetric() {
        return this.defaultMetric;
    }

    public void setDefaultMetric(byte defaultMetric) {
        this.defaultMetric = defaultMetric;
    }

    public void readFrom(ChannelBuffer channelBuffer) {
        byte metric = channelBuffer.readByte();
        this.setDefaultMetric(metric);
        String metricInBinary = Integer.toBinaryString(Byte.toUnsignedInt(metric));
        metricInBinary = IsisUtil.toEightBitBinary(metricInBinary);
        if (metricInBinary.charAt(1) == '\u0000') {
            this.setDefaultIsInternal(true);
        } else {
            this.setDefaultIsInternal(false);
        }
        if (metricInBinary.charAt(0) == '\u0000') {
            this.setDefaultDistributionDown(true);
        } else {
            this.setDefaultDistributionDown(false);
        }
        byte delayMetric = channelBuffer.readByte();
        metricInBinary = Integer.toBinaryString(Byte.toUnsignedInt(delayMetric));
        metricInBinary = IsisUtil.toEightBitBinary(metricInBinary);
        this.setDelayMetric(Byte.parseByte(metricInBinary.substring(5, metricInBinary.length()), 2));
        if (metricInBinary.charAt(1) == '\u0000') {
            this.setDelayIsInternal(true);
        } else {
            this.setDelayIsInternal(false);
        }
        if (metricInBinary.charAt(0) == '\u0000') {
            this.setDelayMetricSupported(true);
        } else {
            this.setDelayMetricSupported(false);
        }
        byte expenseMetric = channelBuffer.readByte();
        metricInBinary = Integer.toBinaryString(Byte.toUnsignedInt(expenseMetric));
        metricInBinary = IsisUtil.toEightBitBinary(metricInBinary);
        this.setExpenseMetric(Byte.parseByte(metricInBinary.substring(5, metricInBinary.length()), 2));
        if (metricInBinary.charAt(1) == '\u0000') {
            this.setExpenseIsInternal(true);
        } else {
            this.setExpenseIsInternal(false);
        }
        if (metricInBinary.charAt(0) == '\u0000') {
            this.setExpenseMetricSupported(true);
        } else {
            this.setExpenseMetricSupported(false);
        }
        byte errorMetric = channelBuffer.readByte();
        metricInBinary = Integer.toBinaryString(Byte.toUnsignedInt(errorMetric));
        metricInBinary = IsisUtil.toEightBitBinary(metricInBinary);
        this.setErrorMetric(Byte.parseByte(metricInBinary.substring(5, metricInBinary.length()), 2));
        if (metricInBinary.charAt(1) == '\u0000') {
            this.setErrorIsInternal(true);
        } else {
            this.setErrorIsInternal(false);
        }
        if (metricInBinary.charAt(0) == '\u0000') {
            this.setErrorMetricSupported(true);
        } else {
            this.setErrorMetricSupported(false);
        }
        byte[] tempByteArray = new byte[4];
        channelBuffer.readBytes(tempByteArray, 0, 4);
        this.setIpAddress(Ip4Address.valueOf((byte[])tempByteArray));
        tempByteArray = new byte[4];
        channelBuffer.readBytes(tempByteArray, 0, 4);
        this.setSubnetAddres(Ip4Address.valueOf((byte[])tempByteArray));
    }

    public byte[] asBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add(this.defaultMetric());
        byte temp = this.delayMetric();
        String hsbBits = "";
        hsbBits = this.isDelayMetricSupported() ? "0" + hsbBits : "1" + hsbBits;
        hsbBits = this.isDelayIsInternal() ? hsbBits + "0" : hsbBits + "1";
        hsbBits = hsbBits + "00";
        String binary = hsbBits + IsisUtil.toFourBitBinary(Integer.toBinaryString(temp));
        bytes.add((byte)Integer.parseInt(binary, 2));
        temp = this.expenseMetric();
        hsbBits = "";
        hsbBits = this.isExpenseMetricSupported() ? "0" + hsbBits : "1" + hsbBits;
        hsbBits = this.isExpenseIsInternal() ? hsbBits + "0" : hsbBits + "1";
        hsbBits = hsbBits + "00";
        binary = hsbBits + IsisUtil.toFourBitBinary(Integer.toBinaryString(temp));
        bytes.add((byte)Integer.parseInt(binary, 2));
        temp = this.errorMetric();
        hsbBits = "";
        hsbBits = this.isErrorMetricSupported() ? "0" + hsbBits : "1" + hsbBits;
        hsbBits = this.isExpenseIsInternal() ? hsbBits + "0" : hsbBits + "1";
        hsbBits = hsbBits + "00";
        binary = hsbBits + IsisUtil.toFourBitBinary(Integer.toBinaryString(temp));
        bytes.add((byte)Integer.parseInt(binary, 2));
        bytes.addAll(Bytes.asList((byte[])this.getIpAddress().toOctets()));
        bytes.addAll(Bytes.asList((byte[])this.getSubnetAddres().toOctets()));
        return Bytes.toArray(bytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ipAddress", (Object)this.ipAddress).add("subnetAddres", (Object)this.subnetAddres).add("defaultMetric", (int)this.defaultMetric).add("delayMetric", (int)this.delayMetric).add("expenseMetric", (int)this.expenseMetric).add("errorMetric", (int)this.errorMetric).add("delayMetricSupported", this.delayMetricSupported).add("expenseMetricSupported", this.expenseMetricSupported).add("errorMetricSupported", this.errorMetricSupported).add("defaultIsInternal", this.defaultIsInternal).add("defaultDistributionDown", this.defaultDistributionDown).add("delayIsInternal", this.delayIsInternal).add("expenseIsInternal", this.expenseIsInternal).add("errorIsInternal", this.errorIsInternal).toString();
    }
}

