/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.util.IsisUtil;

public class MetricsOfReachability {
    private final String value1 = "10000000";
    private final String value2 = "00000000";
    private String neighborId;
    private byte defaultMetric;
    private byte delayMetric;
    private byte expenseMetric;
    private byte errorMetric;
    private boolean delayMetricSupported;
    private boolean expenseMetricSupported;
    private boolean errorMetricSupported;
    private boolean defaultIsInternal;
    private boolean delayIsInternal;
    private boolean expenseIsInternal;
    private boolean errorIsInternal;

    public boolean isDelayIsInternal() {
        return this.delayIsInternal;
    }

    public void setDelayIsInternal(boolean delayIsInternal) {
        this.delayIsInternal = delayIsInternal;
    }

    public boolean isExpenseIsInternal() {
        return this.expenseIsInternal;
    }

    public void setExpenseIsInternal(boolean expenseIsInternal) {
        this.expenseIsInternal = expenseIsInternal;
    }

    public boolean isErrorIsInternal() {
        return this.errorIsInternal;
    }

    public void setErrorIsInternal(boolean errorIsInternal) {
        this.errorIsInternal = errorIsInternal;
    }

    public boolean isDefaultIsInternal() {
        return this.defaultIsInternal;
    }

    public void setDefaultIsInternal(boolean defaultIsInternal) {
        this.defaultIsInternal = defaultIsInternal;
    }

    public boolean isDelayMetricSupported() {
        return this.delayMetricSupported;
    }

    public void setDelayMetricSupported(boolean delayMetricSupported) {
        this.delayMetricSupported = delayMetricSupported;
    }

    public boolean isExpenseMetricSupported() {
        return this.expenseMetricSupported;
    }

    public void setExpenseMetricSupported(boolean expenseMetricSupported) {
        this.expenseMetricSupported = expenseMetricSupported;
    }

    public boolean isErrorMetricSupported() {
        return this.errorMetricSupported;
    }

    public void setErrorMetricSupported(boolean errorMetricSupported) {
        this.errorMetricSupported = errorMetricSupported;
    }

    public String neighborId() {
        return this.neighborId;
    }

    public void setNeighborId(String neighborId) {
        this.neighborId = neighborId;
    }

    public byte defaultMetric() {
        return this.defaultMetric;
    }

    public void setDefaultMetric(byte defaultMetric) {
        this.defaultMetric = defaultMetric;
    }

    public byte delayMetric() {
        return this.delayMetric;
    }

    public void setDelayMetric(byte delayMetric) {
        this.delayMetric = delayMetric;
    }

    public byte expenseMetric() {
        return this.expenseMetric;
    }

    public void setExpenseMetric(byte expenseMetric) {
        this.expenseMetric = expenseMetric;
    }

    public byte errorMetric() {
        return this.errorMetric;
    }

    public void setErrorMetric(byte errorMetric) {
        this.errorMetric = errorMetric;
    }

    public void readFrom(ChannelBuffer channelBuffer) {
        byte metric = channelBuffer.readByte();
        String metricInBinary = Integer.toBinaryString(Byte.toUnsignedInt(metric));
        metricInBinary = IsisUtil.toEightBitBinary(metricInBinary);
        this.setDefaultMetric(metric);
        this.setDelayMetric(metric);
        this.setExpenseMetric(metric);
        this.setErrorMetric(metric);
        this.setDelayMetric(metric);
        if (metricInBinary.charAt(0) == '\u0000') {
            this.setDefaultIsInternal(true);
        } else {
            this.setDefaultIsInternal(false);
        }
        if (metricInBinary.charAt(0) == '\u0000') {
            this.setDelayMetricSupported(true);
            this.setExpenseMetricSupported(true);
            this.setErrorMetricSupported(true);
        } else {
            this.setDelayMetricSupported(false);
            this.setExpenseMetricSupported(false);
            this.setErrorMetricSupported(false);
        }
        byte temp = channelBuffer.readByte();
        String internalBit = Integer.toBinaryString(Byte.toUnsignedInt(temp));
        internalBit = IsisUtil.toEightBitBinary(internalBit);
        if (internalBit.charAt(1) == '\u0000') {
            this.setDelayIsInternal(true);
        }
        temp = channelBuffer.readByte();
        internalBit = Integer.toBinaryString(Byte.toUnsignedInt(temp));
        if ((internalBit = IsisUtil.toEightBitBinary(internalBit)).charAt(1) == '\u0000') {
            this.setExpenseIsInternal(true);
        }
        temp = channelBuffer.readByte();
        internalBit = Integer.toBinaryString(Byte.toUnsignedInt(temp));
        if ((internalBit = IsisUtil.toEightBitBinary(internalBit)).charAt(1) == '\u0000') {
            this.setErrorIsInternal(true);
        }
        byte[] tempByteArray = new byte[7];
        channelBuffer.readBytes(tempByteArray, 0, 7);
        this.setNeighborId(IsisUtil.systemIdPlus(tempByteArray));
    }

    public byte[] asBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add(this.defaultMetric());
        if (this.isDelayIsInternal()) {
            bytes.add((byte)Integer.parseInt("10000000"));
        } else {
            bytes.add((byte)Integer.parseInt("00000000"));
        }
        if (this.isExpenseIsInternal()) {
            bytes.add((byte)Integer.parseInt("10000000"));
        } else {
            bytes.add((byte)Integer.parseInt("00000000"));
        }
        if (this.isErrorIsInternal()) {
            bytes.add((byte)Integer.parseInt("10000000"));
        } else {
            bytes.add((byte)Integer.parseInt("00000000"));
        }
        bytes.addAll(IsisUtil.sourceAndLanIdToBytes(this.neighborId()));
        return Bytes.toArray(bytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("neighborId", (Object)this.neighborId).add("defaultMetric", (int)this.defaultMetric).add("delayMetric", (int)this.delayMetric).add("expenseMetric", (int)this.expenseMetric).add("errorMetric", (int)this.errorMetric).add("delayMetricSupported", this.delayMetricSupported).add("expenseMetricSupported", this.expenseMetricSupported).add("errorMetricSupported", this.errorMetricSupported).add("defaultIsInternal", this.defaultIsInternal).add("delayIsInternal", this.delayIsInternal).add("expenseIsInternal", this.expenseIsInternal).add("errorIsInternal", this.errorIsInternal).toString();
    }
}

