/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvFinder;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvToBytes;
import org.onosproject.isis.io.isispacket.tlv.subtlv.SubTlvType;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.util.IsisUtil;

public class NeighborForExtendedIs {
    private String neighborId;
    private int metric;
    private List<TrafficEngineeringSubTlv> teSubTlv = new ArrayList<TrafficEngineeringSubTlv>();

    public String neighborId() {
        return this.neighborId;
    }

    public List<TrafficEngineeringSubTlv> teSubTlv() {
        return this.teSubTlv;
    }

    public void setNeighborId(String neighborId) {
        this.neighborId = neighborId;
    }

    public int metric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public void addSubTlv(TrafficEngineeringSubTlv trafficEngineeringSubTlv) {
        this.teSubTlv.add(trafficEngineeringSubTlv);
    }

    public void readFrom(ChannelBuffer channelBuffer) {
        byte[] tempByteArray = new byte[7];
        channelBuffer.readBytes(tempByteArray, 0, 7);
        this.setNeighborId(IsisUtil.systemIdPlus(tempByteArray));
        this.setMetric(channelBuffer.readUnsignedMedium());
        byte nTlvPresent = channelBuffer.readByte();
        if (nTlvPresent > 0) {
            while (channelBuffer.readableBytes() > 2) {
                TlvHeader tlvHeader = new TlvHeader();
                tlvHeader.setTlvType(channelBuffer.readByte());
                tlvHeader.setTlvLength(channelBuffer.readByte());
                SubTlvType tlvValue = SubTlvType.get(tlvHeader.tlvType());
                int tlvLength = tlvHeader.tlvLength();
                if (tlvValue != null) {
                    TrafficEngineeringSubTlv subTlv;
                    if (channelBuffer.readableBytes() < tlvLength || (subTlv = SubTlvFinder.findSubTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()))) == null) continue;
                    this.addSubTlv(subTlv);
                    continue;
                }
                if (channelBuffer.readableBytes() < tlvLength) continue;
                channelBuffer.readBytes(tlvLength);
            }
        }
    }

    public byte[] neighborBodyAsbytes() {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.addAll(IsisUtil.sourceAndLanIdToBytes(this.neighborId()));
        byteList.addAll(Bytes.asList((byte[])IsisUtil.convertToThreeBytes(this.metric())));
        if (this.teSubTlv.size() > 0) {
            for (TrafficEngineeringSubTlv trafficEngineeringSubTlv : this.teSubTlv) {
                byteList.addAll(SubTlvToBytes.tlvToBytes(trafficEngineeringSubTlv));
            }
        }
        return Bytes.toArray(byteList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("neighborId", (Object)this.neighborId).add("metric", this.metric).add("teSubTlv", this.teSubTlv).toString();
    }
}

