/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.HostNameTlv;
import org.onosproject.isis.io.isispacket.tlv.IpExtendedReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInternalReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsExtendedReachability;
import org.onosproject.isis.io.isispacket.tlv.IsReachabilityTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntriesTlv;
import org.onosproject.isis.io.isispacket.tlv.PaddingTlv;
import org.onosproject.isis.io.isispacket.tlv.ProtocolSupportedTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TlvsToBytes {
    protected static final Logger log = LoggerFactory.getLogger(TlvsToBytes.class);

    private TlvsToBytes() {
    }

    public static List<Byte> tlvToBytes(IsisTlv isisTlv) {
        ArrayList<Byte> tlvBytes = new ArrayList<Byte>();
        if (isisTlv instanceof AreaAddressTlv) {
            AreaAddressTlv areaAddressTlv = (AreaAddressTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])areaAddressTlv.asBytes()));
        } else if (isisTlv instanceof IpInterfaceAddressTlv) {
            IpInterfaceAddressTlv ipInterfaceAddressTlv = (IpInterfaceAddressTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])ipInterfaceAddressTlv.asBytes()));
        } else if (isisTlv instanceof ProtocolSupportedTlv) {
            ProtocolSupportedTlv protocolSupportedTlv = (ProtocolSupportedTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])protocolSupportedTlv.asBytes()));
        } else if (isisTlv instanceof PaddingTlv) {
            PaddingTlv paddingTlv = (PaddingTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])paddingTlv.asBytes()));
        } else if (isisTlv instanceof IsisNeighborTlv) {
            IsisNeighborTlv isisNeighborTlv = (IsisNeighborTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])isisNeighborTlv.asBytes()));
        } else if (isisTlv instanceof AdjacencyStateTlv) {
            AdjacencyStateTlv isisAdjacencyState = (AdjacencyStateTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])isisAdjacencyState.asBytes()));
        } else if (isisTlv instanceof HostNameTlv) {
            HostNameTlv hostNameTlv = (HostNameTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])hostNameTlv.asBytes()));
        } else if (isisTlv instanceof IpExtendedReachabilityTlv) {
            IpExtendedReachabilityTlv ipExtendedReachabilityTlv = (IpExtendedReachabilityTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])ipExtendedReachabilityTlv.asBytes()));
        } else if (isisTlv instanceof IpInternalReachabilityTlv) {
            IpInternalReachabilityTlv ipInternalReachabilityTlv = (IpInternalReachabilityTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])ipInternalReachabilityTlv.asBytes()));
        } else if (isisTlv instanceof IsReachabilityTlv) {
            IsReachabilityTlv isReachabilityTlv = (IsReachabilityTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])isReachabilityTlv.asBytes()));
        } else if (isisTlv instanceof LspEntriesTlv) {
            LspEntriesTlv lspEntriesTlv = (LspEntriesTlv)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])lspEntriesTlv.asBytes()));
        } else if (isisTlv instanceof IsExtendedReachability) {
            IsExtendedReachability isExtendedReachability = (IsExtendedReachability)isisTlv;
            tlvBytes.addAll(Bytes.asList((byte[])isExtendedReachability.asBytes()));
        } else {
            log.debug("TlvsToBytes::UNKNOWN TLV TYPE ::TlvsToBytes ");
        }
        return tlvBytes;
    }
}

