/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.util.IsisUtil;

public class AdministrativeGroup
extends TlvHeader
implements TrafficEngineeringSubTlv {
    private int administrativeGroup;

    public AdministrativeGroup(TlvHeader header) {
        this.setTlvType(header.tlvType());
        this.setTlvLength(header.tlvLength());
    }

    public int administrativeGroup() {
        return this.administrativeGroup;
    }

    public void setAdministrativeGroup(int administrativeGroup) {
        this.administrativeGroup = administrativeGroup;
    }

    public int getAdministrativeGroupValue() {
        return this.administrativeGroup;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        byte[] tempByteArray = new byte[this.tlvLength()];
        channelBuffer.readBytes(tempByteArray, 0, this.tlvLength());
        this.setAdministrativeGroup(IsisUtil.byteToInteger(tempByteArray));
    }

    @Override
    public byte[] asBytes() {
        byte[] linkSubType = null;
        byte[] linkSubTlvHeader = this.tlvHeaderAsByteArray();
        byte[] linkSubTlvBody = this.tlvBodyAsBytes();
        linkSubType = Bytes.concat((byte[][])new byte[][]{linkSubTlvHeader, linkSubTlvBody});
        return linkSubType;
    }

    public byte[] tlvBodyAsBytes() {
        byte[] linkSubTypeBody = IsisUtil.convertToFourBytes(this.administrativeGroup);
        return linkSubTypeBody;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("administrativeGroup", this.administrativeGroup).toString();
    }
}

