/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.isis.io.isispacket.tlv.subtlv.AdministrativeGroup;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.MaximumReservableBandwidth;
import org.onosproject.isis.io.isispacket.tlv.subtlv.NeighborIpAddress;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringMetric;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.isispacket.tlv.subtlv.UnreservedBandwidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubTlvToBytes {
    protected static final Logger log = LoggerFactory.getLogger(SubTlvToBytes.class);

    private SubTlvToBytes() {
    }

    public static List<Byte> tlvToBytes(TrafficEngineeringSubTlv subTlv) {
        ArrayList<Byte> subTlvBytes = new ArrayList<Byte>();
        if (subTlv instanceof AdministrativeGroup) {
            AdministrativeGroup administrativeGroup = (AdministrativeGroup)subTlv;
            subTlvBytes.addAll(Bytes.asList((byte[])administrativeGroup.asBytes()));
        } else if (subTlv instanceof MaximumBandwidth) {
            MaximumBandwidth maximumBandwidth = (MaximumBandwidth)subTlv;
            subTlvBytes.addAll(Bytes.asList((byte[])maximumBandwidth.asBytes()));
        } else if (subTlv instanceof MaximumReservableBandwidth) {
            MaximumReservableBandwidth maximumReservableBandwidth = (MaximumReservableBandwidth)subTlv;
            subTlvBytes.addAll(Bytes.asList((byte[])maximumReservableBandwidth.asBytes()));
        } else if (subTlv instanceof TrafficEngineeringMetric) {
            TrafficEngineeringMetric trafficEngineeringMetric = (TrafficEngineeringMetric)subTlv;
            subTlvBytes.addAll(Bytes.asList((byte[])trafficEngineeringMetric.asBytes()));
        } else if (subTlv instanceof UnreservedBandwidth) {
            UnreservedBandwidth unreservedBandwidth = (UnreservedBandwidth)subTlv;
            subTlvBytes.addAll(Bytes.asList((byte[])unreservedBandwidth.asBytes()));
        } else if (subTlv instanceof NeighborIpAddress) {
            NeighborIpAddress interfaceIpAddress = (NeighborIpAddress)subTlv;
            subTlvBytes.addAll(Bytes.asList((byte[])interfaceIpAddress.asBytes()));
        } else {
            log.debug("TlvsToBytes::UNKNOWN TLV TYPE ::TlvsToBytes ");
        }
        return subTlvBytes;
    }
}

