/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv.subtlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.subtlv.TrafficEngineeringSubTlv;
import org.onosproject.isis.io.util.IsisUtil;

public class UnreservedBandwidth
extends TlvHeader
implements TrafficEngineeringSubTlv {
    private List<Float> unReservedBandwidth = new ArrayList<Float>();

    public UnreservedBandwidth(TlvHeader header) {
        this.setTlvType(header.tlvType());
        this.setTlvLength(header.tlvLength());
    }

    public void addUnReservedBandwidth(float unreservedBandwidth) {
        this.unReservedBandwidth.add(Float.valueOf(unreservedBandwidth));
    }

    public List<Float> unReservedBandwidthValue() {
        return this.unReservedBandwidth;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 4) {
            int maxReversibleBandwidth = channelBuffer.readInt();
            this.addUnReservedBandwidth(Float.intBitsToFloat(maxReversibleBandwidth));
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] linkSubType = null;
        byte[] linkSubTlvHeader = this.tlvHeaderAsByteArray();
        byte[] linkSubTlvBody = this.tlvBodyAsBytes();
        linkSubType = Bytes.concat((byte[][])new byte[][]{linkSubTlvHeader, linkSubTlvBody});
        return linkSubType;
    }

    public byte[] tlvBodyAsBytes() {
        ArrayList linkSubTypeBody = new ArrayList();
        if (this.unReservedBandwidth.size() < 8) {
            int size = 8 - this.unReservedBandwidth.size();
            for (int i = 0; i < size; ++i) {
                linkSubTypeBody.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(12500000)));
            }
        }
        for (Float unreservedBandwidth : this.unReservedBandwidth) {
            int unresBandwidth = Float.floatToIntBits(unreservedBandwidth.floatValue());
            linkSubTypeBody.addAll(Bytes.asList((byte[])IsisUtil.convertToFourBytes(unresBandwidth)));
        }
        return Bytes.toArray(linkSubTypeBody);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("unReservedBandwidth", this.unReservedBandwidth).toString();
    }
}

