/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.util;

import java.util.Arrays;

public class ChecksumCalculator {
    public boolean validateLspCheckSum(byte[] lspPacket, int lspChecksumPos1, int lspChecksumPos2) {
        byte[] checksum = this.calculateLspChecksum(lspPacket, lspChecksumPos1, lspChecksumPos2);
        return lspPacket[lspChecksumPos1] == checksum[0] && lspPacket[lspChecksumPos2] == checksum[1];
    }

    public byte[] calculateLspChecksum(byte[] lspBytes, int lspChecksumPos1, int lspChecksumPos2) {
        int byte2;
        int byte1;
        byte[] tempLsaByte = Arrays.copyOf(lspBytes, lspBytes.length);
        int[] checksumOut = new int[]{0, 0};
        tempLsaByte[lspChecksumPos1] = 0;
        tempLsaByte[lspChecksumPos2] = 0;
        byte[] byteCheckSum = new byte[]{0, 0};
        if (lspBytes != null) {
            for (int i = 12; i < tempLsaByte.length; ++i) {
                checksumOut[0] = checksumOut[0] + (tempLsaByte[i] & 0xFF);
                checksumOut[1] = checksumOut[1] + checksumOut[0];
            }
            checksumOut[0] = checksumOut[0] % 255;
            checksumOut[1] = checksumOut[1] % 255;
        }
        if ((byte1 = ((tempLsaByte.length - lspChecksumPos1 - 1) * checksumOut[0] - checksumOut[1]) % 255) <= 0) {
            byte1 += 255;
        }
        if ((byte2 = 510 - checksumOut[0] - byte1) > 255) {
            byte2 -= 255;
        }
        byteCheckSum[0] = (byte)byte1;
        byteCheckSum[1] = (byte)byte2;
        return byteCheckSum;
    }
}

