/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.util;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.DatatypeConverter;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.controller.IsisNeighbor;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.P2PHelloPdu;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.PaddingTlv;
import org.onosproject.isis.io.isispacket.tlv.ProtocolSupportedTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.util.ChecksumCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsisUtil {
    public static final int ETHER_HEADER_LEN = 17;
    public static final int ID_SIX_BYTES = 6;
    public static final int ID_PLUS_ONE_BYTE = 7;
    public static final int ID_PLUS_TWO_BYTE = 8;
    public static final int THREE_BYTES = 3;
    public static final int TWO_BYTES = 2;
    public static final int SIX_BYTES = 6;
    public static final int EIGHT_BYTES = 8;
    public static final int FOUR_BYTES = 4;
    public static final int PADDING_FIXED_LENGTH = 255;
    public static final int TLVHEADERLENGTH = 2;
    public static final int INITIAL_BANDWIDTH = 12500000;
    private static final Logger log = LoggerFactory.getLogger(IsisUtil.class);

    private IsisUtil() {
    }

    public static boolean sameNetwork(Ip4Address ip1, Ip4Address ip2, byte[] mask) {
        try {
            byte[] a1 = ip1.toOctets();
            byte[] a2 = ip2.toOctets();
            for (int i = 0; i < a1.length; ++i) {
                if ((a1[i] & mask[i]) == (a2[i] & mask[i])) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.debug("Exception::IsisUtil::sameNetwork:: {}", (Object)e.getMessage());
        }
        return true;
    }

    public static String systemId(byte[] bytes) {
        String systemId = "";
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte byt = byArray[i];
            String hexa = Integer.toHexString(Byte.toUnsignedInt(byt));
            if (hexa.length() % 2 != 0) {
                hexa = "0" + hexa;
            }
            if ((systemId = systemId + hexa).length() != 4 && systemId.length() != 9) continue;
            systemId = systemId + ".";
        }
        return systemId;
    }

    public static String systemIdPlus(byte[] bytes) {
        int count = 1;
        String systemId = "";
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte byt = byArray[i];
            String hexa = Integer.toHexString(Byte.toUnsignedInt(byt));
            if (hexa.length() % 2 != 0) {
                hexa = "0" + hexa;
            }
            if ((systemId = count == 7 && bytes.length == 8 ? systemId + hexa + "-" : systemId + hexa).length() == 4 || systemId.length() == 9 || systemId.length() == 14) {
                systemId = systemId + ".";
            }
            ++count;
        }
        return systemId;
    }

    public static String areaAddres(byte[] bytes) {
        String areaAddres = "";
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte byt = byArray[i];
            String hexa = Integer.toHexString(Byte.toUnsignedInt(byt));
            if (hexa.length() % 2 != 0) {
                hexa = "0" + hexa;
            }
            areaAddres = areaAddres + hexa;
        }
        return areaAddres;
    }

    public static List<Byte> areaAddressToBytes(String address) {
        ArrayList<Byte> idList = new ArrayList<Byte>();
        for (int i = 0; i < address.length(); i += 2) {
            Character c1 = Character.valueOf(address.charAt(i));
            Character c2 = Character.valueOf(address.charAt(i + 1));
            String str = c1.toString() + c2.toString();
            idList.add((byte)Integer.parseInt(str, 16));
        }
        return idList;
    }

    public static int getPduHeaderLength(int pduType) {
        int headerLength = 0;
        switch (IsisPduType.get((int)pduType)) {
            case L1HELLOPDU: 
            case L2HELLOPDU: 
            case L1LSPDU: 
            case L2LSPDU: {
                headerLength = 27;
                break;
            }
            case P2PHELLOPDU: {
                headerLength = 20;
                break;
            }
            case L1PSNP: 
            case L2PSNP: {
                headerLength = 17;
                break;
            }
            case L1CSNP: 
            case L2CSNP: {
                headerLength = 33;
                break;
            }
        }
        return headerLength;
    }

    public static byte[] addLengthAndMarkItInReserved(byte[] isisPacket, int lengthBytePos1, int lengthBytePos2, int reservedBytePos) {
        int length = isisPacket.length;
        byte[] lenthInTwoBytes = IsisUtil.convertToTwoBytes(length);
        isisPacket[lengthBytePos1] = lenthInTwoBytes[0];
        isisPacket[lengthBytePos2] = lenthInTwoBytes[1];
        isisPacket[reservedBytePos] = (byte)lengthBytePos1;
        return isisPacket;
    }

    public static byte[] addChecksum(byte[] isisPacket, int checksumBytePos1, int checksumBytePos2) {
        byte[] checksumInTwoBytes = new ChecksumCalculator().calculateLspChecksum(isisPacket, checksumBytePos1, checksumBytePos2);
        isisPacket[checksumBytePos1] = checksumInTwoBytes[0];
        isisPacket[checksumBytePos2] = checksumInTwoBytes[1];
        return isisPacket;
    }

    public static byte[] framePacket(byte[] isisPacket, int interfaceIndex) {
        int length = isisPacket.length;
        if (length < 1498) {
            byte[] bytes = new byte[1498];
            System.arraycopy(isisPacket, 0, bytes, 0, length);
            bytes[1497] = (byte)interfaceIndex;
            return bytes;
        }
        return isisPacket;
    }

    public static List<Byte> sourceAndLanIdToBytes(String id) {
        ArrayList<Byte> idList = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(id, ".-");
        while (tokenizer.hasMoreElements()) {
            int i = 0;
            String str = tokenizer.nextToken();
            idList.add((byte)Integer.parseInt(str.substring(0, i + 2), 16));
            if (str.length() <= 2) continue;
            idList.add((byte)Integer.parseInt(str.substring(i + 2, str.length()), 16));
        }
        return idList;
    }

    public static byte[] getPaddingTlvs(int currentLength) {
        ArrayList bytes = new ArrayList();
        while (1497 > currentLength) {
            int length = 1497 - currentLength;
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(TlvType.PADDING.value());
            if (length >= 255) {
                tlvHeader.setTlvLength(255);
            } else {
                tlvHeader.setTlvLength(1497 - (currentLength + 2));
            }
            PaddingTlv tlv = new PaddingTlv(tlvHeader);
            bytes.addAll(Bytes.asList((byte[])tlv.asBytes()));
            currentLength = currentLength + tlv.tlvLength() + 2;
        }
        byte[] byteArray = new byte[bytes.size()];
        int i = 0;
        Iterator iterator = bytes.iterator();
        while (iterator.hasNext()) {
            byte byt = (Byte)iterator.next();
            byteArray[i++] = byt;
        }
        return byteArray;
    }

    public static byte[] convertToTwoBytes(int numberToConvert) {
        byte[] hexas;
        byte[] numInBytes = new byte[2];
        String s1 = Integer.toHexString(numberToConvert);
        if (s1.length() % 2 != 0) {
            s1 = "0" + s1;
        }
        if ((hexas = DatatypeConverter.parseHexBinary((String)s1)).length == 1) {
            numInBytes[0] = 0;
            numInBytes[1] = hexas[0];
        } else {
            numInBytes[0] = hexas[0];
            numInBytes[1] = hexas[1];
        }
        return numInBytes;
    }

    public static byte[] convertToFourBytes(int numberToConvert) {
        byte[] hexas;
        byte[] numInBytes = new byte[4];
        String s1 = Integer.toHexString(numberToConvert);
        if (s1.length() % 2 != 0) {
            s1 = "0" + s1;
        }
        if ((hexas = DatatypeConverter.parseHexBinary((String)s1)).length == 1) {
            numInBytes[0] = 0;
            numInBytes[1] = 0;
            numInBytes[2] = 0;
            numInBytes[3] = hexas[0];
        } else if (hexas.length == 2) {
            numInBytes[0] = 0;
            numInBytes[1] = 0;
            numInBytes[2] = hexas[0];
            numInBytes[3] = hexas[1];
        } else if (hexas.length == 3) {
            numInBytes[0] = 0;
            numInBytes[1] = hexas[0];
            numInBytes[2] = hexas[1];
            numInBytes[3] = hexas[2];
        } else {
            numInBytes[0] = hexas[0];
            numInBytes[1] = hexas[1];
            numInBytes[2] = hexas[2];
            numInBytes[3] = hexas[3];
        }
        return numInBytes;
    }

    public static byte[] getP2pHelloPdu(IsisInterface isisInterface, boolean paddingEnabled) {
        byte[] helloMessage;
        IsisHeader isisHeader = new IsisHeader();
        isisHeader.setIrpDiscriminator((byte)-125);
        isisHeader.setPduHeaderLength((byte)20);
        isisHeader.setVersion((byte)1);
        isisHeader.setIdLength((byte)0);
        isisHeader.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        isisHeader.setVersion2((byte)1);
        isisHeader.setReserved((byte)17);
        isisHeader.setMaximumAreaAddresses((byte)0);
        P2PHelloPdu p2pHelloPdu = new P2PHelloPdu(isisHeader);
        p2pHelloPdu.setCircuitType((byte)isisInterface.reservedPacketCircuitType());
        p2pHelloPdu.setSourceId(isisInterface.systemId());
        p2pHelloPdu.setHoldingTime(isisInterface.holdingTime());
        p2pHelloPdu.setPduLength(1497);
        p2pHelloPdu.setLocalCircuitId((byte)-126);
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        tlvHeader.setTlvLength(0);
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress(isisInterface.areaAddress());
        p2pHelloPdu.addTlv(areaAddressTlv);
        tlvHeader.setTlvType(TlvType.PROTOCOLSUPPORTED.value());
        tlvHeader.setTlvLength(0);
        ProtocolSupportedTlv protocolSupportedTlv = new ProtocolSupportedTlv(tlvHeader);
        protocolSupportedTlv.addProtocolSupported((byte)-52);
        p2pHelloPdu.addTlv(protocolSupportedTlv);
        tlvHeader.setTlvType(TlvType.ADJACENCYSTATE.value());
        tlvHeader.setTlvLength(0);
        AdjacencyStateTlv adjacencyStateTlv = new AdjacencyStateTlv(tlvHeader);
        adjacencyStateTlv.setAdjacencyType((byte)IsisInterfaceState.DOWN.value());
        adjacencyStateTlv.setLocalCircuitId(Integer.parseInt(isisInterface.circuitId()));
        Set neighbors = isisInterface.neighbors();
        if (neighbors.size() > 0) {
            IsisNeighbor neighbor = isisInterface.lookup((MacAddress)neighbors.iterator().next());
            adjacencyStateTlv.setAdjacencyType((byte)neighbor.interfaceState().value());
            adjacencyStateTlv.setNeighborSystemId(neighbor.neighborSystemId());
            adjacencyStateTlv.setNeighborLocalCircuitId(neighbor.localExtendedCircuitId());
        }
        p2pHelloPdu.addTlv(adjacencyStateTlv);
        tlvHeader.setTlvType(TlvType.IPINTERFACEADDRESS.value());
        tlvHeader.setTlvLength(0);
        IpInterfaceAddressTlv ipInterfaceAddressTlv = new IpInterfaceAddressTlv(tlvHeader);
        ipInterfaceAddressTlv.addInterfaceAddres(isisInterface.interfaceIpAddress());
        p2pHelloPdu.addTlv(ipInterfaceAddressTlv);
        byte[] beforePadding = p2pHelloPdu.asBytes();
        if (paddingEnabled) {
            byte[] paddingTlvs = IsisUtil.getPaddingTlvs(beforePadding.length);
            helloMessage = Bytes.concat((byte[][])new byte[][]{beforePadding, paddingTlvs});
        } else {
            helloMessage = beforePadding;
        }
        return helloMessage;
    }

    public static byte[] getL1HelloPdu(IsisInterface isisInterface, boolean paddingEnabled) {
        return IsisUtil.getL1OrL2HelloPdu(isisInterface, IsisPduType.L1HELLOPDU, paddingEnabled);
    }

    public static byte[] getL2HelloPdu(IsisInterface isisInterface, boolean paddingEnabled) {
        return IsisUtil.getL1OrL2HelloPdu(isisInterface, IsisPduType.L2HELLOPDU, paddingEnabled);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getL1OrL2HelloPdu(IsisInterface isisInterface, IsisPduType isisPduType, boolean paddingEnabled) {
        void var12_17;
        String lanId = "";
        IsisHeader isisHeader = new IsisHeader();
        isisHeader.setIrpDiscriminator((byte)-125);
        isisHeader.setPduHeaderLength((byte)27);
        isisHeader.setVersion((byte)1);
        isisHeader.setIdLength((byte)0);
        if (isisPduType == IsisPduType.L1HELLOPDU) {
            isisHeader.setIsisPduType(IsisPduType.L1HELLOPDU.value());
            lanId = isisInterface.l1LanId();
        } else if (isisPduType == IsisPduType.L2HELLOPDU) {
            isisHeader.setIsisPduType(IsisPduType.L2HELLOPDU.value());
            lanId = isisInterface.l2LanId();
        }
        isisHeader.setVersion2((byte)1);
        isisHeader.setReserved((byte)17);
        isisHeader.setMaximumAreaAddresses((byte)0);
        L1L2HelloPdu l1L2HelloPdu = new L1L2HelloPdu(isisHeader);
        l1L2HelloPdu.setCircuitType((byte)isisInterface.reservedPacketCircuitType());
        l1L2HelloPdu.setSourceId(isisInterface.systemId());
        l1L2HelloPdu.setHoldingTime(isisInterface.holdingTime());
        l1L2HelloPdu.setPduLength(1497);
        l1L2HelloPdu.setPriority((byte)isisInterface.priority());
        l1L2HelloPdu.setLanId(lanId);
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        tlvHeader.setTlvLength(0);
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress(isisInterface.areaAddress());
        l1L2HelloPdu.addTlv(areaAddressTlv);
        Set neighbors = isisInterface.neighbors();
        if (neighbors.size() > 0) {
            ArrayList<Object> neighborMacs = new ArrayList<Object>();
            for (Object neighbor : neighbors) {
                IsisNeighbor isisNeighbor = isisInterface.lookup((MacAddress)neighbor);
                if (isisPduType == IsisPduType.L1HELLOPDU) {
                    if (isisNeighbor.routerType() != IsisRouterType.L1 && isisNeighbor.routerType() != IsisRouterType.L1L2) continue;
                    neighborMacs.add(neighbor);
                    continue;
                }
                if (isisPduType != IsisPduType.L2HELLOPDU || isisNeighbor.routerType() != IsisRouterType.L2 && isisNeighbor.routerType() != IsisRouterType.L1L2) continue;
                neighborMacs.add(neighbor);
            }
            tlvHeader.setTlvType(TlvType.ISNEIGHBORS.value());
            tlvHeader.setTlvLength(0);
            IsisNeighborTlv isisNeighborTlv = new IsisNeighborTlv(tlvHeader);
            for (MacAddress macAddress : neighborMacs) {
                isisNeighborTlv.addNeighbor(macAddress);
            }
            l1L2HelloPdu.addTlv(isisNeighborTlv);
        }
        tlvHeader.setTlvType(TlvType.PROTOCOLSUPPORTED.value());
        tlvHeader.setTlvLength(0);
        ProtocolSupportedTlv protocolSupportedTlv = new ProtocolSupportedTlv(tlvHeader);
        protocolSupportedTlv.addProtocolSupported((byte)-52);
        l1L2HelloPdu.addTlv(protocolSupportedTlv);
        tlvHeader.setTlvType(TlvType.IPINTERFACEADDRESS.value());
        tlvHeader.setTlvLength(0);
        IpInterfaceAddressTlv ipInterfaceAddressTlv = new IpInterfaceAddressTlv(tlvHeader);
        ipInterfaceAddressTlv.addInterfaceAddres(isisInterface.interfaceIpAddress());
        l1L2HelloPdu.addTlv(ipInterfaceAddressTlv);
        byte[] beforePadding = l1L2HelloPdu.asBytes();
        if (paddingEnabled) {
            byte[] paddingTlvs = IsisUtil.getPaddingTlvs(beforePadding.length);
            byte[] byArray = Bytes.concat((byte[][])new byte[][]{beforePadding, paddingTlvs});
        } else {
            byte[] byArray = beforePadding;
        }
        return var12_17;
    }

    public static int byteToInteger(byte[] bytesToConvert) {
        StringBuilder builder = new StringBuilder();
        for (byte eachByte : bytesToConvert) {
            builder.append(String.format("%02x", eachByte));
        }
        int number = Integer.parseInt(builder.toString(), 16);
        return number;
    }

    public static long byteToLong(byte[] bytesToConvert) {
        StringBuilder builder = new StringBuilder();
        for (byte eachByte : bytesToConvert) {
            builder.append(String.format("%02x", eachByte));
        }
        long number = Long.parseLong(builder.toString(), 16);
        return number;
    }

    public static byte[] convertToFourBytes(long numberToConvert) {
        byte[] hexas;
        byte[] numInBytes = new byte[4];
        String s1 = Long.toHexString(numberToConvert);
        if (s1.length() % 2 != 0) {
            s1 = "0" + s1;
        }
        if (s1.length() == 16) {
            s1 = s1.substring(8, s1.length());
        }
        if ((hexas = DatatypeConverter.parseHexBinary((String)s1)).length == 1) {
            numInBytes[0] = 0;
            numInBytes[1] = 0;
            numInBytes[2] = 0;
            numInBytes[3] = hexas[0];
        } else if (hexas.length == 2) {
            numInBytes[0] = 0;
            numInBytes[1] = 0;
            numInBytes[2] = hexas[0];
            numInBytes[3] = hexas[1];
        } else if (hexas.length == 3) {
            numInBytes[0] = 0;
            numInBytes[1] = hexas[0];
            numInBytes[2] = hexas[1];
            numInBytes[3] = hexas[2];
        } else {
            numInBytes[0] = hexas[0];
            numInBytes[1] = hexas[1];
            numInBytes[2] = hexas[2];
            numInBytes[3] = hexas[3];
        }
        return numInBytes;
    }

    public static String toEightBitBinary(String binaryString) {
        String eightBit = binaryString;
        if (eightBit.length() % 8 != 0) {
            for (int numOfZero = 8 - eightBit.length(); numOfZero > 0; --numOfZero) {
                eightBit = "0" + eightBit;
            }
        }
        return eightBit;
    }

    public static String toFourBitBinary(String binaryString) {
        String fourBit = binaryString;
        if (fourBit.length() % 4 != 0) {
            for (int numOfZero = 4 - fourBit.length(); numOfZero > 0; --numOfZero) {
                fourBit = "0" + fourBit;
            }
        }
        return fourBit;
    }

    public static byte[] convertToThreeBytes(int numberToConvert) {
        byte[] hexas;
        byte[] numInBytes = new byte[3];
        String s1 = Integer.toHexString(numberToConvert);
        if (s1.length() % 2 != 0) {
            s1 = "0" + s1;
        }
        if ((hexas = DatatypeConverter.parseHexBinary((String)s1)).length == 1) {
            numInBytes[0] = 0;
            numInBytes[1] = 0;
            numInBytes[2] = hexas[0];
        } else if (hexas.length == 2) {
            numInBytes[0] = 0;
            numInBytes[1] = hexas[0];
            numInBytes[2] = hexas[1];
        } else {
            numInBytes[0] = hexas[0];
            numInBytes[1] = hexas[1];
            numInBytes[2] = hexas[2];
        }
        return numInBytes;
    }

    public static String prefixConversion(byte[] bytes) {
        String prefix = "";
        for (int i = 0; i < bytes.length; ++i) {
            prefix = i < bytes.length - 1 ? prefix + bytes[i] + "." : prefix + bytes[i];
        }
        return prefix;
    }

    public static byte[] prefixToBytes(String prefix) {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(prefix, ".");
        while (tokenizer.hasMoreTokens()) {
            byteList.add((byte)Integer.parseInt(tokenizer.nextToken()));
        }
        return Bytes.toArray(byteList);
    }

    public static boolean checkIsDis(String systemId) {
        StringTokenizer stringTokenizer = new StringTokenizer(systemId, ".-");
        int count = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int x;
            String str = stringTokenizer.nextToken();
            if (count == 3 && (x = Integer.parseInt(str)) > 0) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public static String removeTailingZeros(String systemId) {
        StringTokenizer stringTokenizer = new StringTokenizer(systemId, "-");
        return stringTokenizer.nextToken();
    }
}

