/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lldpcommon;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.ONOSLLDP;
import org.onlab.util.Timer;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.provider.lldpcommon.LinkDiscoveryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDiscovery
implements TimerTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String SRC_MAC = "DE:AD:BE:EF:BA:11";
    private final Device device;
    private final LinkDiscoveryContext context;
    private final Ethernet ethPacket;
    private final Ethernet bddpEth;
    private Timeout timeout;
    private volatile boolean isStopped;
    private volatile boolean fingerprinted;
    private final Set<Long> ports = Sets.newConcurrentHashSet();

    public LinkDiscovery(Device device, LinkDiscoveryContext context) {
        this.device = device;
        this.context = context;
        this.ethPacket = new Ethernet();
        this.ethPacket.setEtherType(Ethernet.TYPE_LLDP);
        this.ethPacket.setDestinationMACAddress(ONOSLLDP.LLDP_NICIRA);
        this.ethPacket.setPad(true);
        this.bddpEth = new Ethernet();
        this.bddpEth.setEtherType(Ethernet.TYPE_BSN);
        this.bddpEth.setDestinationMACAddress(ONOSLLDP.BDDP_MULTICAST);
        this.bddpEth.setPad(true);
        this.fingerprinted = false;
        this.isStopped = true;
        this.start();
        this.log.debug("Started discovery manager for switch {}", (Object)device.id());
    }

    public synchronized void stop() {
        if (!this.isStopped) {
            this.isStopped = true;
            this.timeout.cancel();
        } else {
            this.log.warn("LinkDiscovery stopped multiple times?");
        }
    }

    public synchronized void start() {
        if (this.isStopped) {
            this.isStopped = false;
            this.timeout = Timer.getTimer().newTimeout((TimerTask)this, 0L, TimeUnit.MILLISECONDS);
        } else {
            this.log.warn("LinkDiscovery started multiple times?");
        }
    }

    public synchronized boolean isStopped() {
        return this.isStopped || this.timeout.isCancelled();
    }

    public void addPort(Port port) {
        boolean newPort = this.ports.add(port.number().toLong());
        boolean isMaster = this.context.mastershipService().isLocalMaster(this.device.id());
        if (newPort && isMaster) {
            this.log.debug("Sending initial probe to port {}@{}", (Object)port.number().toLong(), (Object)this.device.id());
            this.sendProbes(port.number().toLong());
        }
    }

    public void removePort(PortNumber port) {
        this.ports.remove(port.toLong());
    }

    public boolean handleLldp(PacketContext packetContext) {
        Ethernet eth = packetContext.inPacket().parsed();
        if (eth == null) {
            return false;
        }
        ONOSLLDP onoslldp = ONOSLLDP.parseONOSLLDP((Ethernet)eth);
        if (onoslldp != null) {
            if (this.notMy(onoslldp)) {
                return true;
            }
            PortNumber srcPort = PortNumber.portNumber((long)onoslldp.getPort().intValue());
            PortNumber dstPort = packetContext.inPacket().receivedFrom().port();
            DeviceId srcDeviceId = DeviceId.deviceId((String)onoslldp.getDeviceString());
            DeviceId dstDeviceId = packetContext.inPacket().receivedFrom().deviceId();
            ConnectPoint src = new ConnectPoint((ElementId)srcDeviceId, srcPort);
            ConnectPoint dst = new ConnectPoint((ElementId)dstDeviceId, dstPort);
            DefaultLinkDescription ld = eth.getEtherType() == Ethernet.TYPE_LLDP ? new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]) : new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[0]);
            try {
                this.context.providerService().linkDetected((LinkDescription)ld);
                this.context.touchLink(LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst));
            }
            catch (IllegalStateException e) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean notMy(ONOSLLDP onoslldp) {
        if (onoslldp.getDomainTLV() == null) {
            DeviceId src = DeviceId.deviceId((String)onoslldp.getDeviceString());
            return this.context.deviceService().getDevice(src) == null;
        }
        String us = this.context.fingerprint();
        String them = onoslldp.getDomainString();
        if ("".equals(us) || "".equals(them)) {
            return true;
        }
        return !us.equals(them);
    }

    public void run(Timeout t) {
        if (this.isStopped()) {
            return;
        }
        if (this.context.mastershipService().isLocalMaster(this.device.id())) {
            this.log.trace("Sending probes from {}", (Object)this.device.id());
            this.ports.forEach(this::sendProbes);
        }
        if (!this.isStopped()) {
            this.timeout = Timer.getTimer().newTimeout((TimerTask)this, this.context.probeRate(), TimeUnit.MILLISECONDS);
        }
    }

    private OutboundPacket createOutBoundLldp(Long port) {
        if (port == null) {
            return null;
        }
        ONOSLLDP lldp = this.getLinkProbe(port);
        this.ethPacket.setSourceMACAddress(SRC_MAC).setPayload((IPacket)lldp);
        return new DefaultOutboundPacket(this.device.id(), DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)port)).build(), ByteBuffer.wrap(this.ethPacket.serialize()));
    }

    private OutboundPacket createOutBoundBddp(Long port) {
        if (port == null) {
            return null;
        }
        ONOSLLDP lldp = this.getLinkProbe(port);
        this.bddpEth.setSourceMACAddress(SRC_MAC).setPayload((IPacket)lldp);
        return new DefaultOutboundPacket(this.device.id(), DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)port)).build(), ByteBuffer.wrap(this.bddpEth.serialize()));
    }

    private ONOSLLDP getLinkProbe(Long port) {
        return this.fingerprinted ? ONOSLLDP.fingerprintedLLDP((String)this.device.id().toString(), (ChassisId)this.device.chassisId(), (int)port.intValue(), (String)this.context.fingerprint()) : ONOSLLDP.onosLLDP((String)this.device.id().toString(), (ChassisId)this.device.chassisId(), (int)port.intValue());
    }

    private void sendProbes(Long portNumber) {
        this.log.trace("Sending probes out to {}@{}", (Object)portNumber, (Object)this.device.id());
        OutboundPacket pkt = this.createOutBoundLldp(portNumber);
        this.context.packetService().emit(pkt);
        if (this.context.useBddp()) {
            OutboundPacket bpkt = this.createOutBoundBddp(portNumber);
            this.context.packetService().emit(bpkt);
        }
    }

    public boolean containsPort(long portNumber) {
        return this.ports.contains(portNumber);
    }

    public void enableFingerprint() {
        this.fingerprinted = true;
    }

    public void disableFingerprint() {
        this.fingerprinted = false;
    }
}

