/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.SwitchStateException;
import org.onosproject.openflow.controller.impl.Controller;
import org.onosproject.openflow.controller.impl.HandshakeTimeoutException;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncGetReply;
import org.projectfloodlight.openflow.protocol.OFBadRequestCode;
import org.projectfloodlight.openflow.protocol.OFBarrierReply;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFEchoReply;
import org.projectfloodlight.openflow.protocol.OFEchoRequest;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.OFFeaturesRequest;
import org.projectfloodlight.openflow.protocol.OFFlowModFailedCode;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFGetConfigReply;
import org.projectfloodlight.openflow.protocol.OFGetConfigRequest;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.OFHelloElemVersionbitmap;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFQueueGetConfigReply;
import org.projectfloodlight.openflow.protocol.OFRoleReply;
import org.projectfloodlight.openflow.protocol.OFSetConfig;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadRequestErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFFlowModFailedErrorMsg;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFChannelHandler
extends IdleStateAwareChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(OFChannelHandler.class);
    private final Controller controller;
    private OpenFlowSwitchDriver sw;
    private long thisdpid;
    private Channel channel;
    private volatile ChannelState state;
    private volatile Boolean duplicateDpidFound;
    private OFFeaturesReply featuresReply;
    private OFPortDescStatsReply portDescReply;
    private final CopyOnWriteArrayList<OFPortStatus> pendingPortStatusMsg;
    protected OFVersion ofVersion;
    protected OFFactory factory13;
    protected OFFactory factory10;
    private int handshakeTransactionIds = -1;

    OFChannelHandler(Controller controller) {
        this.controller = controller;
        this.state = ChannelState.INIT;
        this.pendingPortStatusMsg = new CopyOnWriteArrayList();
        this.factory13 = controller.getOFMessageFactory13();
        this.factory10 = controller.getOFMessageFactory10();
        this.duplicateDpidFound = Boolean.FALSE;
    }

    public void disconnectSwitch() {
        this.sw.disconnectSwitch();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = e.getChannel();
        log.info("New switch connection from {}", (Object)this.channel.getRemoteAddress());
        this.sendHandshakeHelloMessage();
        this.setState(ChannelState.WAIT_HELLO);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        log.info("Switch disconnected callback for sw:{}. Cleaning up ...", (Object)this.getSwitchInfoString());
        if (this.thisdpid != 0L) {
            if (!this.duplicateDpidFound.booleanValue()) {
                log.info("{}:removal called", (Object)this.getSwitchInfoString());
                if (this.sw != null) {
                    this.sw.removeConnectedSwitch();
                }
            } else {
                log.info("{}:duplicate found", (Object)this.getSwitchInfoString());
                this.duplicateDpidFound = Boolean.FALSE;
            }
        } else {
            log.warn("no dpid in channelHandler registered for disconnected switch {}", (Object)this.getSwitchInfoString());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof ReadTimeoutException) {
            log.error("Disconnecting switch {} due to read timeout", (Object)this.getSwitchInfoString());
            ctx.getChannel().close();
        } else if (e.getCause() instanceof HandshakeTimeoutException) {
            log.error("Disconnecting switch {}: failed to complete handshake", (Object)this.getSwitchInfoString());
            ctx.getChannel().close();
        } else if (e.getCause() instanceof ClosedChannelException) {
            log.debug("Channel for sw {} already closed", (Object)this.getSwitchInfoString());
        } else if (e.getCause() instanceof IOException) {
            log.error("Disconnecting switch {} due to IO Error: {}", (Object)this.getSwitchInfoString(), (Object)e.getCause().getMessage());
            if (log.isDebugEnabled()) {
                log.debug("StackTrace for previous Exception: ", e.getCause());
            }
            ctx.getChannel().close();
        } else if (e.getCause() instanceof SwitchStateException) {
            log.error("Disconnecting switch {} due to switch state error: {}", (Object)this.getSwitchInfoString(), (Object)e.getCause().getMessage());
            if (log.isDebugEnabled()) {
                log.debug("StackTrace for previous Exception: ", e.getCause());
            }
            ctx.getChannel().close();
        } else if (e.getCause() instanceof OFParseError) {
            log.error("Disconnecting switch " + this.getSwitchInfoString() + " due to message parse failure", e.getCause());
            ctx.getChannel().close();
        } else if (e.getCause() instanceof RejectedExecutionException) {
            log.warn("Could not process message: queue full");
        } else {
            log.error("Error while processing message from switch " + this.getSwitchInfoString() + "state " + (Object)((Object)this.state), e.getCause());
            ctx.getChannel().close();
        }
    }

    public String toString() {
        return this.getSwitchInfoString();
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        OFFactory factory = this.ofVersion == OFVersion.OF_13 ? this.factory13 : this.factory10;
        OFEchoRequest m = factory.buildEchoRequest().build();
        log.debug("Sending Echo Request on idle channel: {}", (Object)e.getChannel().getPipeline().getLast().toString());
        e.getChannel().write(Collections.singletonList(m));
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof List) {
            List msglist = (List)e.getMessage();
            for (OFMessage ofm : msglist) {
                this.state.processOFMessage(this, ofm);
            }
        } else {
            this.state.processOFMessage(this, (OFMessage)e.getMessage());
        }
    }

    public boolean isHandshakeComplete() {
        return this.state.isHandshakeComplete();
    }

    private void dispatchMessage(OFMessage m) {
        this.sw.handleMessage(m);
    }

    private String getSwitchInfoString() {
        if (this.sw != null) {
            return this.sw.toString();
        }
        String channelString = this.channel == null || this.channel.getRemoteAddress() == null ? "?" : this.channel.getRemoteAddress().toString();
        String dpidString = this.featuresReply == null ? "?" : this.featuresReply.getDatapathId().toString();
        return String.format("[%s DPID[%s]]", channelString, dpidString);
    }

    private void setState(ChannelState state) {
        this.state = state;
    }

    private void sendHandshakeHelloMessage() throws IOException {
        U32 bitmap = U32.ofRaw((int)18);
        OFHelloElemVersionbitmap hem = this.factory13.buildHelloElemVersionbitmap().setBitmaps(Collections.singletonList(bitmap)).build();
        OFHello.Builder mb = this.factory13.buildHello().setXid((long)this.handshakeTransactionIds--).setElements(Collections.singletonList(hem));
        log.info("Sending OF_13 Hello to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(mb.build()));
    }

    private void sendHandshakeFeaturesRequestMessage() throws IOException {
        OFFactory factory = this.ofVersion == OFVersion.OF_13 ? this.factory13 : this.factory10;
        OFFeaturesRequest m = factory.buildFeaturesRequest().setXid((long)this.handshakeTransactionIds--).build();
        this.channel.write(Collections.singletonList(m));
    }

    private void sendHandshakeSetConfig() throws IOException {
        OFFactory factory = this.ofVersion == OFVersion.OF_13 ? this.factory13 : this.factory10;
        ArrayList<Object> msglist = new ArrayList<Object>(3);
        OFSetConfig sc = factory.buildSetConfig().setMissSendLen(-1).setXid((long)this.handshakeTransactionIds--).build();
        msglist.add(sc);
        OFBarrierRequest br = factory.buildBarrierRequest().setXid((long)this.handshakeTransactionIds--).build();
        msglist.add(br);
        OFGetConfigRequest gcr = factory.buildGetConfigRequest().setXid((long)this.handshakeTransactionIds--).build();
        msglist.add(gcr);
        this.channel.write(msglist);
    }

    private void sendHandshakeDescriptionStatsRequest() throws IOException {
        OFFactory factory = this.ofVersion == OFVersion.OF_13 ? this.factory13 : this.factory10;
        OFDescStatsRequest dreq = factory.buildDescStatsRequest().setXid((long)this.handshakeTransactionIds--).build();
        this.channel.write(Collections.singletonList(dreq));
    }

    private void sendHandshakeOFPortDescRequest() throws IOException {
        OFPortDescStatsRequest preq = this.factory13.buildPortDescStatsRequest().setXid((long)this.handshakeTransactionIds--).build();
        this.channel.write(Collections.singletonList(preq));
    }

    ChannelState getStateForTesting() {
        return this.state;
    }

    static enum ChannelState {
        INIT(false){

            @Override
            void processOFMessage(OFChannelHandler h, OFMessage m) throws IOException, SwitchStateException {
                this.illegalMessageReceived(h, m);
            }

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) throws IOException {
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException {
                this.unhandledMessageReceived(h, (OFMessage)m);
            }
        }
        ,
        WAIT_HELLO(false){

            @Override
            void processOFHello(OFChannelHandler h, OFHello m) throws IOException {
                if (m.getVersion() == OFVersion.OF_13) {
                    log.debug("Received {} Hello from {}", (Object)m.getVersion(), (Object)h.channel.getRemoteAddress());
                    h.ofVersion = OFVersion.OF_13;
                } else if (m.getVersion() == OFVersion.OF_10) {
                    log.debug("Received {} Hello from {} - switching to OF version 1.0", (Object)m.getVersion(), (Object)h.channel.getRemoteAddress());
                    h.ofVersion = OFVersion.OF_10;
                } else {
                    log.error("Received Hello of version {} from switch at {}. This controller works with OF1.0 and OF1.3 switches. Disconnecting switch ...", (Object)m.getVersion(), (Object)h.channel.getRemoteAddress());
                    h.channel.disconnect();
                    return;
                }
                h.sendHandshakeFeaturesRequestMessage();
                h.setState(2.WAIT_FEATURES_REPLY);
            }

            @Override
            void processOFFeaturesReply(OFChannelHandler h, OFFeaturesReply m) throws IOException, SwitchStateException {
                this.illegalMessageReceived(h, (OFMessage)m);
            }

            @Override
            void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) throws IOException, SwitchStateException {
                this.illegalMessageReceived(h, (OFMessage)m);
            }

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) {
                this.logErrorDisconnect(h, m);
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException {
                this.unhandledMessageReceived(h, (OFMessage)m);
            }
        }
        ,
        WAIT_FEATURES_REPLY(false){

            @Override
            void processOFFeaturesReply(OFChannelHandler h, OFFeaturesReply m) throws IOException {
                h.thisdpid = m.getDatapathId().getLong();
                log.debug("Received features reply for switch at {} with dpid {}", (Object)h.getSwitchInfoString(), (Object)h.thisdpid);
                h.featuresReply = m;
                if (h.ofVersion == OFVersion.OF_10) {
                    h.sendHandshakeSetConfig();
                    h.setState(3.WAIT_CONFIG_REPLY);
                } else {
                    h.sendHandshakeOFPortDescRequest();
                    h.setState(3.WAIT_PORT_DESC_REPLY);
                }
            }

            @Override
            void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) throws IOException, SwitchStateException {
                this.illegalMessageReceived(h, (OFMessage)m);
            }

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) {
                this.logErrorDisconnect(h, m);
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException {
                h.pendingPortStatusMsg.add(m);
            }
        }
        ,
        WAIT_PORT_DESC_REPLY(false){

            @Override
            void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) throws SwitchStateException {
                if (m.getStatsType() != OFStatsType.PORT_DESC) {
                    log.warn("Expecting port description stats but received stats type {} from {}. Ignoring ...", (Object)m.getStatsType(), (Object)h.channel.getRemoteAddress());
                    return;
                }
                if (m.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
                    log.warn("Stats reply indicates more stats from sw {} for port description - not currently handled", (Object)h.getSwitchInfoString());
                }
                h.portDescReply = (OFPortDescStatsReply)m;
                log.info("Received port desc reply for switch at {}", (Object)h.getSwitchInfoString());
                try {
                    h.sendHandshakeSetConfig();
                }
                catch (IOException e) {
                    log.error("Unable to send setConfig after PortDescReply. Error: {}", (Object)e.getMessage());
                }
                h.setState(4.WAIT_CONFIG_REPLY);
            }

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) throws IOException, SwitchStateException {
                this.logErrorDisconnect(h, m);
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException, SwitchStateException {
                h.pendingPortStatusMsg.add(m);
            }
        }
        ,
        WAIT_CONFIG_REPLY(false){

            @Override
            void processOFGetConfigReply(OFChannelHandler h, OFGetConfigReply m) throws IOException {
                if (m.getMissSendLen() == 65535) {
                    log.trace("Config Reply from switch {} confirms miss length set to 0xffff", (Object)h.getSwitchInfoString());
                } else {
                    log.warn("Config Reply from switch {} hasmiss length set to {}", (Object)h.getSwitchInfoString(), (Object)m.getMissSendLen());
                }
                h.sendHandshakeDescriptionStatsRequest();
                h.setState(5.WAIT_DESCRIPTION_STAT_REPLY);
            }

            @Override
            void processOFBarrierReply(OFChannelHandler h, OFBarrierReply m) {
            }

            @Override
            void processOFFeaturesReply(OFChannelHandler h, OFFeaturesReply m) throws IOException, SwitchStateException {
                this.illegalMessageReceived(h, (OFMessage)m);
            }

            @Override
            void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) throws IOException, SwitchStateException {
                log.error("Received multipart(stats) message sub-type {}", (Object)m.getStatsType());
                this.illegalMessageReceived(h, (OFMessage)m);
            }

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) {
                this.logErrorDisconnect(h, m);
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException {
                h.pendingPortStatusMsg.add(m);
            }
        }
        ,
        WAIT_DESCRIPTION_STAT_REPLY(false){

            @Override
            void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) throws SwitchStateException {
                if (m.getStatsType() != OFStatsType.DESC) {
                    log.warn("Expecting Description stats but received stats type {} from {}. Ignoring ...", (Object)m.getStatsType(), (Object)h.channel.getRemoteAddress());
                    return;
                }
                log.info("Received switch description reply from switch at {}", (Object)h.channel.getRemoteAddress());
                OFDescStatsReply drep = (OFDescStatsReply)m;
                h.sw = h.controller.getOFSwitchInstance(h.thisdpid, drep, h.ofVersion);
                h.sw.setOFVersion(h.ofVersion);
                h.sw.setFeaturesReply(h.featuresReply);
                h.sw.setPortDescReply(h.portDescReply);
                h.sw.setConnected(true);
                h.sw.setChannel(h.channel);
                log.debug("Switch {} bound to class {}, description {}", new Object[]{h.sw, h.sw.getClass(), drep});
                h.sw.startDriverHandshake();
                if (h.sw.isDriverHandshakeComplete()) {
                    if (!h.sw.connectSwitch()) {
                        this.disconnectDuplicate(h);
                    }
                    this.handlePendingPortStatusMessages(h);
                    h.setState(6.ACTIVE);
                } else {
                    h.setState(6.WAIT_SWITCH_DRIVER_SUB_HANDSHAKE);
                }
            }

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) {
                this.logErrorDisconnect(h, m);
            }

            @Override
            void processOFFeaturesReply(OFChannelHandler h, OFFeaturesReply m) throws IOException, SwitchStateException {
                this.illegalMessageReceived(h, (OFMessage)m);
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException {
                h.pendingPortStatusMsg.add(m);
            }
        }
        ,
        WAIT_SWITCH_DRIVER_SUB_HANDSHAKE(true){

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) throws IOException {
            }

            @Override
            void processOFMessage(OFChannelHandler h, OFMessage m) throws IOException, SwitchStateException {
                if (h.sw.isDriverHandshakeComplete()) {
                    this.moveToActive(h);
                    h.state.processOFMessage(h, m);
                    return;
                }
                if (m.getType() == OFType.ECHO_REQUEST) {
                    this.processOFEchoRequest(h, (OFEchoRequest)m);
                } else if (m.getType() == OFType.ECHO_REPLY) {
                    this.processOFEchoReply(h, (OFEchoReply)m);
                } else if (m.getType() == OFType.ROLE_REPLY) {
                    h.sw.handleRole(m);
                } else if (m.getType() == OFType.ERROR) {
                    if (!h.sw.handleRoleError((OFErrorMsg)m)) {
                        h.sw.processDriverHandshakeMessage(m);
                        if (h.sw.isDriverHandshakeComplete()) {
                            this.moveToActive(h);
                        }
                    }
                } else if (m.getType() == OFType.EXPERIMENTER && ((OFExperimenter)m).getExperimenter() == 8992L) {
                    h.sw.handleNiciraRole(m);
                } else {
                    h.sw.processDriverHandshakeMessage(m);
                    if (h.sw.isDriverHandshakeComplete()) {
                        this.moveToActive(h);
                    }
                }
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws IOException, SwitchStateException {
                h.pendingPortStatusMsg.add(m);
            }

            private void moveToActive(OFChannelHandler h) {
                boolean success = h.sw.connectSwitch();
                this.handlePendingPortStatusMessages(h);
                h.setState(7.ACTIVE);
                if (!success) {
                    this.disconnectDuplicate(h);
                }
            }
        }
        ,
        ACTIVE(true){

            @Override
            void processOFError(OFChannelHandler h, OFErrorMsg m) throws IOException, SwitchStateException {
                if (m.getErrType() == OFErrorType.BAD_REQUEST && ((OFBadRequestErrorMsg)m).getCode() == OFBadRequestCode.EPERM) {
                    h.sw.reassertRole();
                } else if (m.getErrType() == OFErrorType.FLOW_MOD_FAILED && ((OFFlowModFailedErrorMsg)m).getCode() == OFFlowModFailedCode.ALL_TABLES_FULL) {
                    h.sw.setTableFull(true);
                } else {
                    this.logError(h, m);
                }
                h.dispatchMessage((OFMessage)m);
            }

            @Override
            void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) {
                if (m.getStatsType().equals((Object)OFStatsType.PORT_DESC)) {
                    h.sw.setPortDescReply((OFPortDescStatsReply)m);
                }
                h.dispatchMessage((OFMessage)m);
            }

            @Override
            void processOFExperimenter(OFChannelHandler h, OFExperimenter m) throws SwitchStateException {
                h.sw.handleNiciraRole((OFMessage)m);
            }

            @Override
            void processOFRoleReply(OFChannelHandler h, OFRoleReply m) throws SwitchStateException {
                h.sw.handleRole((OFMessage)m);
            }

            @Override
            void processOFPortStatus(OFChannelHandler h, OFPortStatus m) throws SwitchStateException {
                this.handlePortStatusMessage(h, m, true);
            }

            @Override
            void processOFPacketIn(OFChannelHandler h, OFPacketIn m) {
                h.dispatchMessage((OFMessage)m);
            }

            @Override
            void processOFFlowRemoved(OFChannelHandler h, OFFlowRemoved m) {
                h.dispatchMessage((OFMessage)m);
            }

            @Override
            void processOFBarrierReply(OFChannelHandler h, OFBarrierReply m) {
                h.dispatchMessage((OFMessage)m);
            }

            @Override
            void processOFFeaturesReply(OFChannelHandler h, OFFeaturesReply m) {
                h.sw.setFeaturesReply(m);
                h.dispatchMessage((OFMessage)m);
            }
        };

        private final boolean handshakeComplete;

        private ChannelState(boolean handshakeComplete) {
            this.handshakeComplete = handshakeComplete;
        }

        public boolean isHandshakeComplete() {
            return this.handshakeComplete;
        }

        protected String getSwitchStateMessage(OFChannelHandler h, OFMessage m, String details) {
            return String.format("Switch: [%s], State: [%s], received: [%s], details: %s", h.getSwitchInfoString(), this.toString(), m.getType().toString(), details);
        }

        protected void illegalMessageReceived(OFChannelHandler h, OFMessage m) throws SwitchStateException {
            String msg = this.getSwitchStateMessage(h, m, "Switch should never send this message in the current state");
            throw new SwitchStateException(msg);
        }

        protected void unhandledMessageReceived(OFChannelHandler h, OFMessage m) {
            if (log.isDebugEnabled()) {
                String msg = this.getSwitchStateMessage(h, m, "Ignoring unexpected message");
                log.debug(msg);
            }
        }

        protected void logError(OFChannelHandler h, OFErrorMsg error) {
            log.error("{} from switch {} in state {}", new Object[]{error, h.getSwitchInfoString(), this.toString()});
        }

        protected void logErrorDisconnect(OFChannelHandler h, OFErrorMsg error) {
            this.logError(h, error);
            h.channel.disconnect();
        }

        protected void disconnectDuplicate(OFChannelHandler h) {
            log.error("Duplicated dpid or incompleted cleanup - disconnecting channel {}", (Object)h.getSwitchInfoString());
            h.duplicateDpidFound = Boolean.TRUE;
            h.channel.disconnect();
        }

        protected void handlePendingPortStatusMessages(OFChannelHandler h) {
            try {
                this.handlePendingPortStatusMessages(h, 0);
            }
            catch (SwitchStateException e) {
                log.error(e.getMessage());
            }
        }

        private void handlePendingPortStatusMessages(OFChannelHandler h, int index) throws SwitchStateException {
            if (h.sw == null) {
                String msg = "State machine error: switch is null. Should never happen";
                throw new SwitchStateException(msg);
            }
            log.info("Processing {} pending port status messages for {}", (Object)h.pendingPortStatusMsg.size(), (Object)h.sw.getStringId());
            ArrayList<OFPortStatus> temp = new ArrayList<OFPortStatus>();
            for (OFPortStatus ps : h.pendingPortStatusMsg) {
                temp.add(ps);
                this.handlePortStatusMessage(h, ps, false);
            }
            h.pendingPortStatusMsg.removeAll(temp);
            temp.clear();
            if (!h.pendingPortStatusMsg.isEmpty() && ++index < 5) {
                this.handlePendingPortStatusMessages(h, index);
            }
        }

        protected void handlePortStatusMessage(OFChannelHandler h, OFPortStatus m, boolean doNotify) throws SwitchStateException {
            if (h.sw == null) {
                String msg = this.getSwitchStateMessage(h, (OFMessage)m, "State machine error: switch is null. Should never happen");
                throw new SwitchStateException(msg);
            }
            h.sw.handleMessage((OFMessage)m);
        }

        void processOFMessage(OFChannelHandler h, OFMessage m) throws IOException, SwitchStateException {
            switch (m.getType()) {
                case HELLO: {
                    this.processOFHello(h, (OFHello)m);
                    break;
                }
                case BARRIER_REPLY: {
                    this.processOFBarrierReply(h, (OFBarrierReply)m);
                    break;
                }
                case ECHO_REPLY: {
                    this.processOFEchoReply(h, (OFEchoReply)m);
                    break;
                }
                case ECHO_REQUEST: {
                    this.processOFEchoRequest(h, (OFEchoRequest)m);
                    break;
                }
                case ERROR: {
                    this.processOFError(h, (OFErrorMsg)m);
                    break;
                }
                case FEATURES_REPLY: {
                    this.processOFFeaturesReply(h, (OFFeaturesReply)m);
                    break;
                }
                case FLOW_REMOVED: {
                    this.processOFFlowRemoved(h, (OFFlowRemoved)m);
                    break;
                }
                case GET_CONFIG_REPLY: {
                    this.processOFGetConfigReply(h, (OFGetConfigReply)m);
                    break;
                }
                case PACKET_IN: {
                    this.processOFPacketIn(h, (OFPacketIn)m);
                    break;
                }
                case PORT_STATUS: {
                    this.processOFPortStatus(h, (OFPortStatus)m);
                    break;
                }
                case QUEUE_GET_CONFIG_REPLY: {
                    this.processOFQueueGetConfigReply(h, (OFQueueGetConfigReply)m);
                    break;
                }
                case STATS_REPLY: {
                    this.processOFStatisticsReply(h, (OFStatsReply)m);
                    break;
                }
                case EXPERIMENTER: {
                    this.processOFExperimenter(h, (OFExperimenter)m);
                    break;
                }
                case ROLE_REPLY: {
                    this.processOFRoleReply(h, (OFRoleReply)m);
                    break;
                }
                case GET_ASYNC_REPLY: {
                    this.processOFGetAsyncReply(h, (OFAsyncGetReply)m);
                    break;
                }
                default: {
                    this.illegalMessageReceived(h, m);
                }
            }
        }

        void processOFHello(OFChannelHandler h, OFHello m) throws IOException, SwitchStateException {
            this.illegalMessageReceived(h, (OFMessage)m);
        }

        void processOFBarrierReply(OFChannelHandler h, OFBarrierReply m) throws IOException {
        }

        void processOFEchoRequest(OFChannelHandler h, OFEchoRequest m) throws IOException {
            if (h.ofVersion == null) {
                log.error("No OF version set for {}. Not sending Echo REPLY", (Object)h.channel.getRemoteAddress());
                return;
            }
            OFFactory factory = h.ofVersion == OFVersion.OF_13 ? h.controller.getOFMessageFactory13() : h.controller.getOFMessageFactory10();
            OFEchoReply reply = factory.buildEchoReply().setXid(m.getXid()).setData(m.getData()).build();
            h.channel.write(Collections.singletonList(reply));
        }

        void processOFEchoReply(OFChannelHandler h, OFEchoReply m) throws IOException {
        }

        abstract void processOFError(OFChannelHandler var1, OFErrorMsg var2) throws IOException, SwitchStateException;

        void processOFFeaturesReply(OFChannelHandler h, OFFeaturesReply m) throws IOException, SwitchStateException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        void processOFFlowRemoved(OFChannelHandler h, OFFlowRemoved m) throws IOException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        void processOFGetConfigReply(OFChannelHandler h, OFGetConfigReply m) throws IOException, SwitchStateException {
            this.illegalMessageReceived(h, (OFMessage)m);
        }

        void processOFPacketIn(OFChannelHandler h, OFPacketIn m) throws IOException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        abstract void processOFPortStatus(OFChannelHandler var1, OFPortStatus var2) throws IOException, SwitchStateException;

        void processOFQueueGetConfigReply(OFChannelHandler h, OFQueueGetConfigReply m) throws IOException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        void processOFStatisticsReply(OFChannelHandler h, OFStatsReply m) throws IOException, SwitchStateException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        void processOFExperimenter(OFChannelHandler h, OFExperimenter m) throws IOException, SwitchStateException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        void processOFRoleReply(OFChannelHandler h, OFRoleReply m) throws SwitchStateException, IOException {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }

        void processOFGetAsyncReply(OFChannelHandler h, OFAsyncGetReply m) {
            this.unhandledMessageReceived(h, (OFMessage)m);
        }
    }
}

