/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.openflow.controller.DefaultOpenFlowPacketContext;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.OpenFlowAgent;
import org.onosproject.openflow.controller.impl.Controller;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFFlowStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OpenFlowControllerImpl
implements OpenFlowController {
    private static final Logger log = LoggerFactory.getLogger(OpenFlowControllerImpl.class);
    private final ExecutorService executorMsgs = Executors.newFixedThreadPool(32, Tools.namedThreads((String)"of-event-stats-%d"));
    private final ExecutorService executorBarrier = Executors.newFixedThreadPool(4, Tools.namedThreads((String)"of-event-barrier-%d"));
    protected ConcurrentHashMap<Dpid, OpenFlowSwitch> connectedSwitches = new ConcurrentHashMap();
    protected ConcurrentHashMap<Dpid, OpenFlowSwitch> activeMasterSwitches = new ConcurrentHashMap();
    protected ConcurrentHashMap<Dpid, OpenFlowSwitch> activeEqualSwitches = new ConcurrentHashMap();
    protected OpenFlowSwitchAgent agent = new OpenFlowSwitchAgent();
    protected Set<OpenFlowSwitchListener> ofSwitchListener = new HashSet<OpenFlowSwitchListener>();
    protected Multimap<Integer, PacketListener> ofPacketListener = ArrayListMultimap.create();
    protected Set<OpenFlowEventListener> ofEventListener = Sets.newHashSet();
    protected Multimap<Dpid, OFFlowStatsEntry> fullStats = ArrayListMultimap.create();
    private final Controller ctrl = new Controller();

    @Activate
    public void activate() {
        this.ctrl.start(this.agent);
    }

    @Deactivate
    public void deactivate() {
        this.ctrl.stop();
    }

    public Iterable<OpenFlowSwitch> getSwitches() {
        return this.connectedSwitches.values();
    }

    public Iterable<OpenFlowSwitch> getMasterSwitches() {
        return this.activeMasterSwitches.values();
    }

    public Iterable<OpenFlowSwitch> getEqualSwitches() {
        return this.activeEqualSwitches.values();
    }

    public OpenFlowSwitch getSwitch(Dpid dpid) {
        return this.connectedSwitches.get(dpid);
    }

    public OpenFlowSwitch getMasterSwitch(Dpid dpid) {
        return this.activeMasterSwitches.get(dpid);
    }

    public OpenFlowSwitch getEqualSwitch(Dpid dpid) {
        return this.activeEqualSwitches.get(dpid);
    }

    public void addListener(OpenFlowSwitchListener listener) {
        if (!this.ofSwitchListener.contains(listener)) {
            this.ofSwitchListener.add(listener);
        }
    }

    public void removeListener(OpenFlowSwitchListener listener) {
        this.ofSwitchListener.remove(listener);
    }

    public void addPacketListener(int priority, PacketListener listener) {
        this.ofPacketListener.put((Object)priority, (Object)listener);
    }

    public void removePacketListener(PacketListener listener) {
        this.ofPacketListener.values().remove(listener);
    }

    public void addEventListener(OpenFlowEventListener listener) {
        this.ofEventListener.add(listener);
    }

    public void removeEventListener(OpenFlowEventListener listener) {
        this.ofEventListener.remove(listener);
    }

    public void write(Dpid dpid, OFMessage msg) {
        this.getSwitch(dpid).sendMsg(msg);
    }

    public void processPacket(Dpid dpid, OFMessage msg) {
        switch (msg.getType()) {
            case PORT_STATUS: {
                for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                    l.portChanged(dpid, (OFPortStatus)msg);
                }
                break;
            }
            case FEATURES_REPLY: {
                for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                    l.switchChanged(dpid);
                }
                break;
            }
            case PACKET_IN: {
                OpenFlowPacketContext pktCtx = DefaultOpenFlowPacketContext.packetContextFromPacketIn((OpenFlowSwitch)this.getSwitch(dpid), (OFPacketIn)((OFPacketIn)msg));
                for (PacketListener p : this.ofPacketListener.values()) {
                    p.handlePacket(pktCtx);
                }
                break;
            }
            case FLOW_REMOVED: 
            case ERROR: {
                this.executorMsgs.submit(new OFMessageHandler(dpid, msg));
                break;
            }
            case STATS_REPLY: {
                Collection<OFFlowStatsEntry> stats;
                OFStatsReply reply = (OFStatsReply)msg;
                if (reply.getStatsType().equals((Object)OFStatsType.PORT_DESC)) {
                    for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                        l.switchChanged(dpid);
                    }
                }
                if ((stats = this.publishStats(dpid, reply)) == null) break;
                OFFlowStatsReply.Builder rep = OFFactories.getFactory((OFVersion)msg.getVersion()).buildFlowStatsReply();
                rep.setEntries((List)Lists.newLinkedList(stats));
                this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)rep.build()));
                break;
            }
            case BARRIER_REPLY: {
                this.executorBarrier.submit(new OFMessageHandler(dpid, msg));
                break;
            }
            case EXPERIMENTER: {
                if (((OFExperimenter)msg).getExperimenter() == 7636849L) {
                    OFCircuitPortStatus circuitPortStatus = (OFCircuitPortStatus)msg;
                    OFPortStatus.Builder portStatus = this.getSwitch(dpid).factory().buildPortStatus();
                    OFPortDesc.Builder portDesc = this.getSwitch(dpid).factory().buildPortDesc();
                    portDesc.setPortNo(circuitPortStatus.getPortNo()).setHwAddr(circuitPortStatus.getHwAddr()).setName(circuitPortStatus.getName()).setConfig(circuitPortStatus.getConfig()).setState(circuitPortStatus.getState());
                    portStatus.setReason(circuitPortStatus.getReason()).setDesc(portDesc.build());
                    for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                        l.portChanged(dpid, portStatus.build());
                    }
                    break;
                }
                log.warn("Handling experimenter type {} not yet implemented", (Object)((OFExperimenter)msg).getExperimenter(), (Object)msg);
                break;
            }
            default: {
                log.warn("Handling message type {} not yet implemented {}", (Object)msg.getType(), (Object)msg);
            }
        }
    }

    private synchronized Collection<OFFlowStatsEntry> publishStats(Dpid dpid, OFStatsReply reply) {
        if (reply.getStatsType() != OFStatsType.FLOW) {
            return null;
        }
        OFFlowStatsReply replies = (OFFlowStatsReply)reply;
        this.fullStats.putAll((Object)dpid, (Iterable)replies.getEntries());
        if (!reply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
            return this.fullStats.removeAll((Object)dpid);
        }
        return null;
    }

    public void setRole(Dpid dpid, RoleState role) {
        OpenFlowSwitch sw = this.getSwitch(dpid);
        if (sw == null) {
            log.debug("Switch not connected. Ignoring setRole({}, {})", (Object)dpid, (Object)role);
            return;
        }
        sw.setRole(role);
    }

    private final class OFMessageHandler
    implements Runnable {
        private final OFMessage msg;
        private final Dpid dpid;

        public OFMessageHandler(Dpid dpid, OFMessage msg) {
            this.msg = msg;
            this.dpid = dpid;
        }

        @Override
        public void run() {
            for (OpenFlowEventListener listener : OpenFlowControllerImpl.this.ofEventListener) {
                listener.handleMessage(this.dpid, this.msg);
            }
        }
    }

    public class OpenFlowSwitchAgent
    implements OpenFlowAgent {
        private final Logger log = LoggerFactory.getLogger(OpenFlowSwitchAgent.class);
        private final Lock switchLock = new ReentrantLock();

        public boolean addConnectedSwitch(Dpid dpid, OpenFlowSwitch sw) {
            if (OpenFlowControllerImpl.this.connectedSwitches.get(dpid) != null) {
                this.log.error("Trying to add connectedSwitch but found a previous value for dpid: {}", (Object)dpid);
                return false;
            }
            this.log.info("Added switch {}", (Object)dpid);
            OpenFlowControllerImpl.this.connectedSwitches.put(dpid, sw);
            for (OpenFlowSwitchListener l : OpenFlowControllerImpl.this.ofSwitchListener) {
                l.switchAdded(dpid);
            }
            return true;
        }

        public boolean validActivation(Dpid dpid) {
            if (OpenFlowControllerImpl.this.connectedSwitches.get(dpid) == null) {
                this.log.error("Trying to activate switch but is not in connected switches: dpid {}. Aborting ..", (Object)dpid);
                return false;
            }
            if (OpenFlowControllerImpl.this.activeMasterSwitches.get(dpid) != null || OpenFlowControllerImpl.this.activeEqualSwitches.get(dpid) != null) {
                this.log.error("Trying to activate switch but it is already activated: dpid {}. Found in activeMaster: {} Found in activeEqual: {}. Aborting ..", new Object[]{dpid, Character.valueOf(OpenFlowControllerImpl.this.activeMasterSwitches.get(dpid) == null ? (char)'N' : 'Y'), Character.valueOf(OpenFlowControllerImpl.this.activeEqualSwitches.get(dpid) == null ? (char)'N' : 'Y')});
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addActivatedMasterSwitch(Dpid dpid, OpenFlowSwitch sw) {
            this.switchLock.lock();
            try {
                if (!this.validActivation(dpid)) {
                    boolean bl = false;
                    return bl;
                }
                OpenFlowControllerImpl.this.activeMasterSwitches.put(dpid, sw);
                boolean bl = true;
                return bl;
            }
            finally {
                this.switchLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addActivatedEqualSwitch(Dpid dpid, OpenFlowSwitch sw) {
            this.switchLock.lock();
            try {
                if (!this.validActivation(dpid)) {
                    boolean bl = false;
                    return bl;
                }
                OpenFlowControllerImpl.this.activeEqualSwitches.put(dpid, sw);
                this.log.info("Added Activated EQUAL Switch {}", (Object)dpid);
                boolean bl = true;
                return bl;
            }
            finally {
                this.switchLock.unlock();
            }
        }

        public void transitionToMasterSwitch(Dpid dpid) {
            this.switchLock.lock();
            try {
                if (OpenFlowControllerImpl.this.activeMasterSwitches.containsKey(dpid)) {
                    return;
                }
                OpenFlowSwitch sw = OpenFlowControllerImpl.this.activeEqualSwitches.remove(dpid);
                if (sw == null && (sw = OpenFlowControllerImpl.this.getSwitch(dpid)) == null) {
                    this.log.error("Transition to master called on sw {}, but switch was not found in controller-cache", (Object)dpid);
                    return;
                }
                this.log.info("Transitioned switch {} to MASTER", (Object)dpid);
                OpenFlowControllerImpl.this.activeMasterSwitches.put(dpid, sw);
            }
            finally {
                this.switchLock.unlock();
            }
        }

        public void transitionToEqualSwitch(Dpid dpid) {
            this.switchLock.lock();
            try {
                if (OpenFlowControllerImpl.this.activeEqualSwitches.containsKey(dpid)) {
                    return;
                }
                OpenFlowSwitch sw = OpenFlowControllerImpl.this.activeMasterSwitches.remove(dpid);
                if (sw == null && (sw = OpenFlowControllerImpl.this.getSwitch(dpid)) == null) {
                    this.log.error("Transition to equal called on sw {}, but switch was not found in controller-cache", (Object)dpid);
                    return;
                }
                this.log.info("Transitioned switch {} to EQUAL", (Object)dpid);
                OpenFlowControllerImpl.this.activeEqualSwitches.put(dpid, sw);
            }
            finally {
                this.switchLock.unlock();
            }
        }

        public void removeConnectedSwitch(Dpid dpid) {
            OpenFlowControllerImpl.this.connectedSwitches.remove(dpid);
            OpenFlowSwitch sw = OpenFlowControllerImpl.this.activeMasterSwitches.remove(dpid);
            if (sw == null) {
                this.log.warn("sw was null for {}", (Object)dpid);
                sw = OpenFlowControllerImpl.this.activeEqualSwitches.remove(dpid);
            }
            for (OpenFlowSwitchListener l : OpenFlowControllerImpl.this.ofSwitchListener) {
                this.log.warn("removal for {}", (Object)dpid);
                l.switchRemoved(dpid);
            }
        }

        public void processMessage(Dpid dpid, OFMessage m) {
            OpenFlowControllerImpl.this.processPacket(dpid, m);
        }

        public void returnRoleReply(Dpid dpid, RoleState requested, RoleState response) {
            for (OpenFlowSwitchListener l : OpenFlowControllerImpl.this.ofSwitchListener) {
                l.receivedRoleReply(dpid, requested, response);
            }
        }
    }
}

