/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.io.IOException;
import java.util.List;
import org.jboss.netty.channel.Channel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.OpenFlowAgent;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.RoleHandler;
import org.onosproject.openflow.controller.driver.RoleRecvStatus;
import org.onosproject.openflow.controller.driver.RoleReplyInfo;
import org.onosproject.openflow.controller.driver.SwitchStateException;
import org.onosproject.openflow.controller.impl.RoleManager;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class RoleManagerTest {
    private static final U64 GID = U64.of((long)10L);
    private static final long XID = 1L;
    private OpenFlowSwitchDriver sw;
    private RoleManager manager;

    @Before
    public void setUp() {
        this.sw = new TestSwitchDriver();
        this.manager = new RoleManager(this.sw);
    }

    @After
    public void tearDown() {
        this.manager = null;
        this.sw = null;
    }

    @Test
    public void deliverRoleReply() {
        RoleReplyInfo asserted = new RoleReplyInfo(RoleState.MASTER, GID, 1L);
        RoleReplyInfo unasserted = new RoleReplyInfo(RoleState.SLAVE, GID, 1L);
        try {
            RoleRecvStatus status = this.manager.deliverRoleReply(asserted);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.OTHER_EXPECTATION, (Object)status);
            this.sw.setRole(RoleState.MASTER);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.OTHER_EXPECTATION, (Object)status);
            this.sw.setRole(RoleState.SLAVE);
            this.manager.sendRoleRequest(RoleState.MASTER, RoleRecvStatus.MATCHED_CURRENT_ROLE);
            status = this.manager.deliverRoleReply(asserted);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.MATCHED_CURRENT_ROLE, (Object)status);
            status = this.manager.deliverRoleReply(unasserted);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.OTHER_EXPECTATION, (Object)status);
            Assert.assertEquals((String)"pending role mismatch", (Object)RoleState.MASTER, (Object)((TestSwitchDriver)this.sw).failed);
        }
        catch (IOException | SwitchStateException e) {
            Assert.assertEquals((String)"unexpected error thrown", SwitchStateException.class, e.getClass());
        }
    }

    private class TestSwitchDriver
    implements OpenFlowSwitchDriver {
        RoleState failed = null;
        RoleState current = null;

        private TestSwitchDriver() {
        }

        public void sendMsg(OFMessage msg) {
        }

        public void sendMsg(List<OFMessage> msgs) {
        }

        public void transformAndSendMsg(OFMessage msg, OpenFlowSwitch.TableType tableType) {
        }

        public void handleMessage(OFMessage fromSwitch) {
        }

        public void setRole(RoleState role) {
            this.current = role;
        }

        public RoleState getRole() {
            return this.current;
        }

        public List<OFPortDesc> getPorts() {
            return null;
        }

        public OFFactory factory() {
            return OFFactories.getFactory((OFVersion)OFVersion.OF_10);
        }

        public String getStringId() {
            return "100";
        }

        public long getId() {
            return 0L;
        }

        public String manufacturerDescription() {
            return null;
        }

        public String datapathDescription() {
            return null;
        }

        public String hardwareDescription() {
            return null;
        }

        public String softwareDescription() {
            return null;
        }

        public String serialNumber() {
            return null;
        }

        public void disconnectSwitch() {
        }

        public boolean isOptical() {
            return false;
        }

        public void setAgent(OpenFlowAgent agent) {
        }

        public void setRoleHandler(RoleHandler roleHandler) {
        }

        public void reassertRole() {
        }

        public boolean handleRoleError(OFErrorMsg error) {
            return false;
        }

        public void handleNiciraRole(OFMessage m) throws SwitchStateException {
        }

        public void handleRole(OFMessage m) throws SwitchStateException {
        }

        public void startDriverHandshake() {
        }

        public boolean isDriverHandshakeComplete() {
            return false;
        }

        public void processDriverHandshakeMessage(OFMessage m) {
        }

        public boolean connectSwitch() {
            return false;
        }

        public boolean activateMasterSwitch() {
            return false;
        }

        public boolean activateEqualSwitch() {
            return false;
        }

        public void transitionToEqualSwitch() {
        }

        public void transitionToMasterSwitch() {
        }

        public void removeConnectedSwitch() {
        }

        public void setPortDescReply(OFPortDescStatsReply portDescReply) {
        }

        public void setFeaturesReply(OFFeaturesReply featuresReply) {
        }

        public void setSwitchDescription(OFDescStatsReply desc) {
        }

        public int getNextTransactionId() {
            return 1;
        }

        public Boolean supportNxRole() {
            return true;
        }

        public void setOFVersion(OFVersion ofV) {
        }

        public void setTableFull(boolean full) {
        }

        public void setChannel(Channel channel) {
        }

        public void setConnected(boolean connected) {
        }

        public boolean isConnected() {
            return false;
        }

        public void write(OFMessage msg) {
        }

        public void write(List<OFMessage> msgs) {
        }

        public void returnRoleReply(RoleState requested, RoleState response) {
            this.failed = requested;
        }

        public String channelId() {
            return "1.2.3.4:1";
        }

        public OpenFlowSwitch.TableType getTableType(TableId tid) {
            return OpenFlowSwitch.TableType.NONE;
        }
    }
}

