/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onlab.util.Tools;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.driver.OpenFlowAgent;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.RoleHandler;
import org.onosproject.openflow.controller.impl.OpenflowPipelineFactory;
import org.onosproject.openflow.controller.impl.RoleManager;
import org.onosproject.openflow.drivers.DriverManager;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    protected static final Logger log = LoggerFactory.getLogger(Controller.class);
    protected static final OFFactory FACTORY13 = OFFactories.getFactory((OFVersion)OFVersion.OF_13);
    protected static final OFFactory FACTORY10 = OFFactories.getFactory((OFVersion)OFVersion.OF_10);
    protected HashMap<String, String> controllerNodeIPsCache;
    private ChannelGroup cg;
    protected int openFlowPort = 6633;
    protected int workerThreads = 0;
    protected long systemStartTime;
    private OpenFlowAgent agent;
    private NioServerSocketChannelFactory execFactory;
    protected static final int SEND_BUFFER_SIZE = 0x400000;

    public OFFactory getOFMessageFactory10() {
        return FACTORY10;
    }

    public OFFactory getOFMessageFactory13() {
        return FACTORY13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getControllerNodeIPs() {
        HashMap<String, String> retval = new HashMap<String, String>();
        HashMap<String, String> hashMap = this.controllerNodeIPsCache;
        synchronized (hashMap) {
            retval.putAll(this.controllerNodeIPsCache);
        }
        return retval;
    }

    public long getSystemStartTime() {
        return this.systemStartTime;
    }

    public void run() {
        try {
            ServerBootstrap bootstrap = this.createServerBootStrap();
            bootstrap.setOption("reuseAddr", (Object)true);
            bootstrap.setOption("child.keepAlive", (Object)true);
            bootstrap.setOption("child.tcpNoDelay", (Object)true);
            bootstrap.setOption("child.sendBufferSize", (Object)0x400000);
            OpenflowPipelineFactory pfact = new OpenflowPipelineFactory(this, null);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)pfact);
            InetSocketAddress sa = new InetSocketAddress(this.openFlowPort);
            this.cg = new DefaultChannelGroup();
            this.cg.add((Object)bootstrap.bind((SocketAddress)sa));
            log.info("Listening for switch connections on {}", (Object)sa);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ServerBootstrap createServerBootStrap() {
        if (this.workerThreads == 0) {
            this.execFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"worker-%d")));
            return new ServerBootstrap((ChannelFactory)this.execFactory);
        }
        this.execFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/of", (String)"worker-%d")), this.workerThreads);
        return new ServerBootstrap((ChannelFactory)this.execFactory);
    }

    public void setConfigParams(Map<String, String> configParams) {
        String corsaDpid;
        String ofPort = configParams.get("openflowport");
        if (ofPort != null) {
            this.openFlowPort = Integer.parseInt(ofPort);
        }
        if ((corsaDpid = configParams.get("corsaDpid")) != null) {
            try {
                DriverManager.setCorsaDpid((Dpid)new Dpid(corsaDpid));
                log.info("Corsa DPID set to {}", (Object)corsaDpid);
            }
            catch (NumberFormatException e) {
                log.warn("Malformed Corsa DPID string", (Throwable)e);
            }
        }
        log.debug("OpenFlow port set to {}", (Object)this.openFlowPort);
        String threads = configParams.get("workerthreads");
        this.workerThreads = threads != null ? Integer.parseInt(threads) : 16;
        log.debug("Number of worker threads set to {}", (Object)this.workerThreads);
    }

    public void init() {
        this.controllerNodeIPsCache = new HashMap();
        this.systemStartTime = System.currentTimeMillis();
    }

    public Map<String, Long> getMemory() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        Runtime runtime = Runtime.getRuntime();
        m.put("total", runtime.totalMemory());
        m.put("free", runtime.freeMemory());
        return m;
    }

    public Long getUptime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        return rb.getUptime();
    }

    protected OpenFlowSwitchDriver getOFSwitchInstance(long dpid, OFDescStatsReply desc, OFVersion ofv) {
        OpenFlowSwitchDriver sw = DriverManager.getSwitch((Dpid)new Dpid(dpid), (OFDescStatsReply)desc, (OFVersion)ofv);
        sw.setAgent(this.agent);
        sw.setRoleHandler((RoleHandler)new RoleManager(sw));
        return sw;
    }

    public void start(OpenFlowAgent ag) {
        log.info("Starting OpenFlow IO");
        this.agent = ag;
        this.init();
        this.run();
    }

    public void stop() {
        log.info("Stopping OpenFlow IO");
        this.execFactory.shutdown();
        this.cg.close();
    }
}

