/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.onosproject.openflow.controller.impl.HandshakeTimeoutException;
import org.onosproject.openflow.controller.impl.OFChannelHandler;

public class HandshakeTimeoutHandler
extends SimpleChannelUpstreamHandler {
    static final HandshakeTimeoutException EXCEPTION = new HandshakeTimeoutException();
    final OFChannelHandler channelHandler;
    final Timer timer;
    final long timeoutNanos;
    volatile Timeout timeout;

    public HandshakeTimeoutHandler(OFChannelHandler channelHandler, Timer timer, long timeoutSeconds) {
        this.channelHandler = channelHandler;
        this.timer = timer;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(timeoutSeconds);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.timeoutNanos > 0L) {
            this.timeout = this.timer.newTimeout((TimerTask)new HandshakeTimeoutTask(ctx), this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.timeout != null) {
            this.timeout.cancel();
            this.timeout = null;
        }
    }

    private final class HandshakeTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        HandshakeTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout t) throws Exception {
            if (t.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            if (!HandshakeTimeoutHandler.this.channelHandler.isHandshakeComplete()) {
                Channels.fireExceptionCaught((ChannelHandlerContext)this.ctx, (Throwable)EXCEPTION);
            }
        }
    }
}

