/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.RoleHandler;
import org.onosproject.openflow.controller.driver.RoleRecvStatus;
import org.onosproject.openflow.controller.driver.RoleReplyInfo;
import org.onosproject.openflow.controller.driver.SwitchStateException;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFNiciraControllerRole;
import org.projectfloodlight.openflow.protocol.OFNiciraControllerRoleReply;
import org.projectfloodlight.openflow.protocol.OFNiciraControllerRoleRequest;
import org.projectfloodlight.openflow.protocol.OFRoleReply;
import org.projectfloodlight.openflow.protocol.OFRoleRequest;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadRequestErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFRoleRequestFailedErrorMsg;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleManager
implements RoleHandler {
    protected static final long NICIRA_EXPERIMENTER = 8992L;
    private static Logger log = LoggerFactory.getLogger(RoleManager.class);
    private final int pendingXidTimeoutSeconds = 60;
    private Cache<Integer, RoleState> pendingReplies = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    private RoleRecvStatus expectation = RoleRecvStatus.MATCHED_CURRENT_ROLE;
    private final OpenFlowSwitchDriver sw;

    public RoleManager(OpenFlowSwitchDriver sw) {
        this.sw = sw;
    }

    private int sendNxRoleRequest(RoleState role) throws IOException {
        OFNiciraControllerRole roleToSend = OFNiciraControllerRole.ROLE_OTHER;
        switch (role) {
            case MASTER: {
                roleToSend = OFNiciraControllerRole.ROLE_MASTER;
                break;
            }
            default: {
                roleToSend = OFNiciraControllerRole.ROLE_OTHER;
                log.debug("Sending Nx Role.SLAVE to switch {}.", (Object)this.sw);
            }
        }
        int xid = this.sw.getNextTransactionId();
        OFNiciraControllerRoleRequest roleRequest = OFFactories.getFactory((OFVersion)OFVersion.OF_10).buildNiciraControllerRoleRequest().setXid((long)xid).setRole(roleToSend).build();
        this.sw.sendRoleRequest((OFMessage)roleRequest);
        return xid;
    }

    private int sendOF13RoleRequest(RoleState role) throws IOException {
        OFControllerRole roleToSend = OFControllerRole.ROLE_NOCHANGE;
        switch (role) {
            case EQUAL: {
                roleToSend = OFControllerRole.ROLE_EQUAL;
                break;
            }
            case MASTER: {
                roleToSend = OFControllerRole.ROLE_MASTER;
                break;
            }
            case SLAVE: {
                roleToSend = OFControllerRole.ROLE_SLAVE;
                break;
            }
            default: {
                log.warn("Sending default role.noChange to switch {}. Should only be used for queries.", (Object)this.sw);
            }
        }
        int xid = this.sw.getNextTransactionId();
        OFRoleRequest rrm = OFFactories.getFactory((OFVersion)OFVersion.OF_13).buildRoleRequest().setRole(roleToSend).setXid((long)xid).setGenerationId(U64.ZERO).build();
        this.sw.sendRoleRequest((OFMessage)rrm);
        return xid;
    }

    public synchronized boolean sendRoleRequest(RoleState role, RoleRecvStatus exp) throws IOException {
        this.expectation = exp;
        if (this.sw.factory().getVersion() == OFVersion.OF_10) {
            Boolean supportsNxRole = this.sw.supportNxRole();
            if (!supportsNxRole.booleanValue()) {
                log.debug("Switch driver indicates no support for Nicira role request messages. Not sending ...");
                this.handleUnsentRoleMessage(role, this.expectation);
                return false;
            }
            RoleState roleToSend = role == RoleState.EQUAL ? RoleState.SLAVE : role;
            this.pendingReplies.put((Object)this.sendNxRoleRequest(roleToSend), (Object)role);
        } else {
            this.pendingReplies.put((Object)this.sendOF13RoleRequest(role), (Object)role);
        }
        return true;
    }

    private void handleUnsentRoleMessage(RoleState role, RoleRecvStatus exp) throws IOException {
        if (exp != RoleRecvStatus.MATCHED_SET_ROLE) {
            log.error("Expected MASTER role from registry for switch which has no support for role-messages.Received {}. It is possible that this switch is connected to other controllers, in which case it should support role messages - not moving forward.", (Object)role);
        }
    }

    public synchronized RoleRecvStatus deliverRoleReply(RoleReplyInfo rri) throws SwitchStateException {
        int xid = (int)rri.getXid();
        RoleState receivedRole = rri.getRole();
        RoleState expectedRole = (RoleState)this.pendingReplies.getIfPresent((Object)xid);
        if (expectedRole == null) {
            RoleState currentRole;
            RoleState roleState = currentRole = this.sw != null ? this.sw.getRole() : null;
            if (currentRole != null) {
                if (currentRole == rri.getRole()) {
                    log.debug("Received unexpected RoleReply from Switch: {}. Role in reply is same as current role of this controller for this sw. Ignoring ...", (Object)this.sw.getStringId());
                    return RoleRecvStatus.OTHER_EXPECTATION;
                }
                String msg = String.format("Switch: [%s], received unexpected RoleReply[%s]. No roles are pending, and this controller's current role:[%s] does not match reply. Disconnecting switch ... ", this.sw.getStringId(), rri, currentRole);
                throw new SwitchStateException(msg);
            }
            log.debug("Received unexpected RoleReply {} from Switch: {}. This controller has no current role for this sw. Ignoring ...", new Object[]{rri, this.sw == null ? "(null)" : this.sw.getStringId()});
            return RoleRecvStatus.OTHER_EXPECTATION;
        }
        this.sw.returnRoleReply(expectedRole, receivedRole);
        if (expectedRole == receivedRole) {
            log.debug("Received role reply message from {} that matched expected role-reply {} with expectations {}", new Object[]{this.sw.getStringId(), receivedRole, this.expectation});
            this.pendingReplies.invalidate((Object)xid);
            if (this.expectation == RoleRecvStatus.MATCHED_CURRENT_ROLE || this.expectation == RoleRecvStatus.MATCHED_SET_ROLE) {
                return this.expectation;
            }
            return RoleRecvStatus.OTHER_EXPECTATION;
        }
        this.pendingReplies.invalidate((Object)xid);
        if (this.expectation == RoleRecvStatus.REPLY_QUERY) {
            return this.expectation;
        }
        return RoleRecvStatus.OTHER_EXPECTATION;
    }

    public synchronized RoleRecvStatus deliverError(OFErrorMsg error) throws SwitchStateException {
        RoleState errorRole = (RoleState)this.pendingReplies.getIfPresent((Object)error.getXid());
        if (errorRole == null) {
            if (error.getErrType() == OFErrorType.ROLE_REQUEST_FAILED) {
                log.debug("Received an error msg from sw {} for a role request, but not for pending request in role-changer;  ignoring error {} ...", (Object)this.sw.getStringId(), (Object)error);
            } else {
                log.debug("Received an error msg from sw {}, but no pending requests in role-changer; not handling ...", (Object)this.sw.getStringId());
            }
            return RoleRecvStatus.OTHER_EXPECTATION;
        }
        if (error.getErrType() == OFErrorType.BAD_REQUEST) {
            log.error("Received a error msg {} from sw {} for pending role request {}. Switch driver indicates role-messaging is supported. Possible issues in switch driver configuration?", new Object[]{((OFBadRequestErrorMsg)error).toString(), this.sw.getStringId(), errorRole});
            return RoleRecvStatus.UNSUPPORTED;
        }
        if (error.getErrType() == OFErrorType.ROLE_REQUEST_FAILED) {
            OFRoleRequestFailedErrorMsg rrerr = (OFRoleRequestFailedErrorMsg)error;
            switch (rrerr.getCode()) {
                case BAD_ROLE: 
                case STALE: 
                case UNSUP: {
                    String msgx = String.format("Switch: [%s], received Error to for pending role request [%s]. Error:[%s]. Disconnecting switch ... ", this.sw.getStringId(), errorRole, rrerr);
                    throw new SwitchStateException(msgx);
                }
            }
        }
        return RoleRecvStatus.OTHER_EXPECTATION;
    }

    public RoleState extractNiciraRoleReply(OFExperimenter experimenterMsg) throws SwitchStateException {
        int vendor = (int)experimenterMsg.getExperimenter();
        if (vendor != 8992) {
            return null;
        }
        OFNiciraControllerRoleReply nrr = (OFNiciraControllerRoleReply)experimenterMsg;
        RoleState role = null;
        OFNiciraControllerRole ncr = nrr.getRole();
        switch (ncr) {
            case ROLE_MASTER: {
                role = RoleState.MASTER;
                break;
            }
            case ROLE_OTHER: {
                role = RoleState.EQUAL;
                break;
            }
            case ROLE_SLAVE: {
                role = RoleState.SLAVE;
                break;
            }
        }
        if (role == null) {
            String msg = String.format("Switch: [%s], received NX_ROLE_REPLY with invalid role value %s", this.sw.getStringId(), nrr.getRole());
            throw new SwitchStateException(msg);
        }
        return role;
    }

    public RoleReplyInfo extractOFRoleReply(OFRoleReply rrmsg) throws SwitchStateException {
        OFControllerRole cr = rrmsg.getRole();
        RoleState role = null;
        switch (cr) {
            case ROLE_EQUAL: {
                role = RoleState.EQUAL;
                break;
            }
            case ROLE_MASTER: {
                role = RoleState.MASTER;
                break;
            }
            case ROLE_SLAVE: {
                role = RoleState.SLAVE;
                break;
            }
            default: {
                String msg = String.format("Unknown controller role %s received from switch %s", cr, this.sw);
                throw new SwitchStateException(msg);
            }
        }
        return new RoleReplyInfo(role, rrmsg.getGenerationId(), rrmsg.getXid());
    }
}

